/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ShulkerBoxRenderer
implements BlockEntityRenderer<ShulkerBoxBlockEntity> {
    private final ShulkerModel<?> model;

    public ShulkerBoxRenderer(BlockEntityRendererProvider.Context pContext) {
        this.model = new ShulkerModel(pContext.bakeLayer(ModelLayers.SHULKER));
    }

    @Override
    public void render(ShulkerBoxBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        DyeColor dyecolor;
        BlockState blockstate;
        Direction direction = Direction.UP;
        if (pBlockEntity.hasLevel() && (blockstate = pBlockEntity.getLevel().getBlockState(pBlockEntity.getBlockPos())).getBlock() instanceof ShulkerBoxBlock) {
            direction = blockstate.getValue(ShulkerBoxBlock.FACING);
        }
        Material material = (dyecolor = pBlockEntity.getColor()) == null ? Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION : Sheets.SHULKER_TEXTURE_LOCATION.get(dyecolor.getId());
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.5, 0.5);
        float f = 0.9995f;
        pPoseStack.scale(0.9995f, 0.9995f, 0.9995f);
        pPoseStack.mulPose(direction.getRotation());
        pPoseStack.scale(1.0f, -1.0f, -1.0f);
        pPoseStack.translate(0.0, -1.0, 0.0);
        ModelPart modelpart = this.model.getLid();
        modelpart.setPos(0.0f, 24.0f - pBlockEntity.getProgress(pPartialTick) * 0.5f * 16.0f, 0.0f);
        modelpart.yRot = 270.0f * pBlockEntity.getProgress(pPartialTick) * ((float)Math.PI / 180);
        VertexConsumer vertexconsumer = material.buffer(pBufferSource, RenderType::entityCutoutNoCull);
        this.model.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.popPose();
    }
}

