/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.shaders.Shaders;

public class SignRenderer
implements BlockEntityRenderer<SignBlockEntity> {
    public static final int MAX_LINE_WIDTH = 90;
    private static final int LINE_HEIGHT = 10;
    private static final String STICK = "stick";
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.square(16);
    private final Map<WoodType, SignModel> signModels = (Map)WoodType.values().collect(ImmutableMap.toImmutableMap(woodTypeIn -> woodTypeIn, woodTypeIn -> new SignModel(pContext.bakeLayer(ModelLayers.createSignModelName(woodTypeIn)))));
    private final Font font;
    private static double textRenderDistanceSq = 4096.0;

    public SignRenderer(BlockEntityRendererProvider.Context pContext) {
        this.font = pContext.getFont();
    }

    @Override
    public void render(SignBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockState blockstate = pBlockEntity.getBlockState();
        pPoseStack.pushPose();
        float f = 0.6666667f;
        WoodType woodtype = SignRenderer.getWoodType(blockstate.getBlock());
        SignModel signrenderer$signmodel = this.signModels.get(woodtype);
        if (blockstate.getBlock() instanceof StandingSignBlock) {
            pPoseStack.translate(0.5, 0.5, 0.5);
            float f1 = -((float)(blockstate.getValue(StandingSignBlock.ROTATION) * 360) / 16.0f);
            pPoseStack.mulPose(Vector3f.YP.rotationDegrees(f1));
            signrenderer$signmodel.stick.visible = true;
        } else {
            pPoseStack.translate(0.5, 0.5, 0.5);
            float f4 = -blockstate.getValue(WallSignBlock.FACING).toYRot();
            pPoseStack.mulPose(Vector3f.YP.rotationDegrees(f4));
            pPoseStack.translate(0.0, -0.3125, -0.4375);
            signrenderer$signmodel.stick.visible = false;
        }
        pPoseStack.pushPose();
        pPoseStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        Material material = Sheets.getSignMaterial(woodtype);
        VertexConsumer vertexconsumer = material.buffer(pBufferSource, signrenderer$signmodel::renderType);
        signrenderer$signmodel.root.render(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.popPose();
        if (SignRenderer.isRenderText(pBlockEntity)) {
            int l;
            boolean flag;
            int k;
            float f2 = 0.010416667f;
            pPoseStack.translate(0.0, 0.3333333432674408, 0.046666666865348816);
            pPoseStack.scale(0.010416667f, -0.010416667f, 0.010416667f);
            int i = SignRenderer.getDarkColor(pBlockEntity);
            int j = 20;
            FormattedCharSequence[] aformattedcharsequence = pBlockEntity.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), componentIn -> {
                List<FormattedCharSequence> list = this.font.split((FormattedText)componentIn, 90);
                return list.isEmpty() ? FormattedCharSequence.EMPTY : list.get(0);
            });
            if (pBlockEntity.hasGlowingText()) {
                k = pBlockEntity.getColor().getTextColor();
                if (Config.isCustomColors()) {
                    k = CustomColors.getSignTextColor(k);
                }
                flag = SignRenderer.isOutlineVisible(pBlockEntity, k);
                l = 0xF000F0;
            } else {
                k = i;
                flag = false;
                l = pPackedLight;
            }
            int i1 = 0;
            while (i1 < 4) {
                FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
                float f3 = -this.font.width(formattedcharsequence) / 2;
                if (flag) {
                    this.font.drawInBatch8xOutline(formattedcharsequence, f3, i1 * 10 - 20, k, i, pPoseStack.last().pose(), pBufferSource, l);
                } else {
                    this.font.drawInBatch(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, false, pPoseStack.last().pose(), pBufferSource, false, 0, l);
                }
                ++i1;
            }
        }
        pPoseStack.popPose();
    }

    private static boolean isOutlineVisible(SignBlockEntity pBlockEntity, int pTextColor) {
        if (pTextColor == DyeColor.BLACK.getTextColor()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        if (localplayer != null && minecraft.options.getCameraType().isFirstPerson() && localplayer.isScoping()) {
            return true;
        }
        Entity entity = minecraft.getCameraEntity();
        return entity != null && entity.distanceToSqr(Vec3.atCenterOf(pBlockEntity.getBlockPos())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static int getDarkColor(SignBlockEntity pBlockEntity) {
        int i = pBlockEntity.getColor().getTextColor();
        if (Config.isCustomColors()) {
            i = CustomColors.getSignTextColor(i);
        }
        double d0 = 0.4;
        int j = (int)((double)NativeImage.getR(i) * 0.4);
        int k = (int)((double)NativeImage.getG(i) * 0.4);
        int l = (int)((double)NativeImage.getB(i) * 0.4);
        return i == DyeColor.BLACK.getTextColor() && pBlockEntity.hasGlowingText() ? -988212 : NativeImage.combine(0, l, k, j);
    }

    public static WoodType getWoodType(Block pBlock) {
        WoodType woodtype = pBlock instanceof SignBlock ? ((SignBlock)pBlock).type() : WoodType.OAK;
        return woodtype;
    }

    public static SignModel createSignModel(EntityModelSet pEntityModelSet, WoodType pWoodType) {
        return new SignModel(pEntityModelSet.bakeLayer(ModelLayers.createSignModelName(pWoodType)));
    }

    public static LayerDefinition createSignLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("sign", CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(STICK, CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    private static boolean isRenderText(SignBlockEntity tileEntity) {
        if (Shaders.isShadowPass) {
            return false;
        }
        if (!Config.zoomMode) {
            BlockPos blockpos = tileEntity.getBlockPos();
            Entity entity = Minecraft.getInstance().getCameraEntity();
            double d0 = entity.distanceToSqr(blockpos.getX(), blockpos.getY(), blockpos.getZ());
            if (d0 > textRenderDistanceSq) {
                return false;
            }
        }
        return true;
    }

    public static void updateTextRenderDistance() {
        Minecraft minecraft = Minecraft.getInstance();
        double d0 = Config.limit(minecraft.options.fov, 1.0, 120.0);
        double d1 = Math.max(1.5 * (double)minecraft.getWindow().getScreenHeight() / d0, 16.0);
        textRenderDistanceSq = d1 * d1;
    }

    public static final class SignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart stick;

        public SignModel(ModelPart pRoot) {
            super(RenderType::entityCutoutNoCull);
            this.root = pRoot;
            this.stick = pRoot.getChilds(SignRenderer.STICK);
        }

        @Override
        public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
            this.root.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
    }
}

