/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.dragon.DragonHeadModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;

public class SkullBlockRenderer
implements BlockEntityRenderer<SkullBlockEntity> {
    private final Map<SkullBlock.Type, SkullModelBase> modelByType;
    private static final Map<SkullBlock.Type, ResourceLocation> SKIN_BY_TYPE = Util.make(Maps.newHashMap(), mapIn -> {
        mapIn.put(SkullBlock.Types.SKELETON, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
        mapIn.put(SkullBlock.Types.WITHER_SKELETON, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
        mapIn.put(SkullBlock.Types.ZOMBIE, new ResourceLocation("textures/entity/zombie/zombie.png"));
        mapIn.put(SkullBlock.Types.CREEPER, new ResourceLocation("textures/entity/creeper/creeper.png"));
        mapIn.put(SkullBlock.Types.DRAGON, new ResourceLocation("textures/entity/enderdragon/dragon.png"));
        mapIn.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.getDefaultSkin());
    });
    private static EntityModelSet modelSet;
    public static Map<SkullBlock.Type, SkullModelBase> models;

    public static Map<SkullBlock.Type, SkullModelBase> createSkullRenderers(EntityModelSet pEntityModelSet) {
        if (pEntityModelSet == modelSet) {
            return models;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)SkullBlock.Types.SKELETON, (Object)new SkullModel(pEntityModelSet.bakeLayer(ModelLayers.SKELETON_SKULL)));
        builder.put((Object)SkullBlock.Types.WITHER_SKELETON, (Object)new SkullModel(pEntityModelSet.bakeLayer(ModelLayers.WITHER_SKELETON_SKULL)));
        builder.put((Object)SkullBlock.Types.PLAYER, (Object)new SkullModel(pEntityModelSet.bakeLayer(ModelLayers.PLAYER_HEAD)));
        builder.put((Object)SkullBlock.Types.ZOMBIE, (Object)new SkullModel(pEntityModelSet.bakeLayer(ModelLayers.ZOMBIE_HEAD)));
        builder.put((Object)SkullBlock.Types.CREEPER, (Object)new SkullModel(pEntityModelSet.bakeLayer(ModelLayers.CREEPER_HEAD)));
        builder.put((Object)SkullBlock.Types.DRAGON, (Object)new DragonHeadModel(pEntityModelSet.bakeLayer(ModelLayers.DRAGON_SKULL)));
        ReflectorForge.postModLoaderEvent(Reflector.EntityRenderersEvent_CreateSkullModels_Constructor, builder, pEntityModelSet);
        HashMap<SkullBlock.Type, SkullModelBase> map = new HashMap<SkullBlock.Type, SkullModelBase>((Map<SkullBlock.Type, SkullModelBase>)builder.build());
        modelSet = pEntityModelSet;
        models = map;
        return map;
    }

    public SkullBlockRenderer(BlockEntityRendererProvider.Context pContext) {
        this.modelByType = SkullBlockRenderer.createSkullRenderers(pContext.getModelSet());
    }

    @Override
    public void render(SkullBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        float f = pBlockEntity.getMouthAnimation(pPartialTick);
        BlockState blockstate = pBlockEntity.getBlockState();
        boolean flag = blockstate.getBlock() instanceof WallSkullBlock;
        Direction direction = flag ? blockstate.getValue(WallSkullBlock.FACING) : null;
        float f1 = 22.5f * (float)(flag ? (2 + direction.get2DDataValue()) * 4 : blockstate.getValue(SkullBlock.ROTATION));
        SkullBlock.Type skullblock$type = ((AbstractSkullBlock)blockstate.getBlock()).getType();
        SkullModelBase skullmodelbase = this.modelByType.get(skullblock$type);
        RenderType rendertype = SkullBlockRenderer.getRenderType(skullblock$type, pBlockEntity.getOwnerProfile());
        SkullBlockRenderer.renderSkull(direction, f1, f, pPoseStack, pBufferSource, pPackedLight, skullmodelbase, rendertype);
    }

    public static void renderSkull(@Nullable Direction pDirection, float pYRot, float pMouthAnimation, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, SkullModelBase pModel, RenderType pRenderType) {
        pPoseStack.pushPose();
        if (pDirection == null) {
            pPoseStack.translate(0.5, 0.0, 0.5);
        } else {
            float f = 0.25f;
            pPoseStack.translate(0.5f - (float)pDirection.getStepX() * 0.25f, 0.25, 0.5f - (float)pDirection.getStepZ() * 0.25f);
        }
        pPoseStack.scale(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexconsumer = pBufferSource.getBuffer(pRenderType);
        pModel.setupAnim(pMouthAnimation, pYRot, 0.0f);
        pModel.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.popPose();
    }

    public static RenderType getRenderType(SkullBlock.Type pSkullType, @Nullable GameProfile pGameProfile) {
        ResourceLocation resourcelocation = SKIN_BY_TYPE.get(pSkullType);
        if (pSkullType == SkullBlock.Types.PLAYER && pGameProfile != null) {
            Minecraft minecraft = Minecraft.getInstance();
            Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = minecraft.getSkinManager().getInsecureSkinInformation(pGameProfile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.entityTranslucent(minecraft.getSkinManager().registerTexture(map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.entityCutoutNoCull(DefaultPlayerSkin.getDefaultSkin(Player.createPlayerUUID(pGameProfile)));
        }
        return RenderType.entityCutoutNoCullZOffset(resourcelocation);
    }
}

