/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;

public class SpawnerRenderer
implements BlockEntityRenderer<SpawnerBlockEntity> {
    public SpawnerRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    @Override
    public void render(SpawnerBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.0, 0.5);
        BaseSpawner basespawner = pBlockEntity.getSpawner();
        Entity entity = basespawner.getOrCreateDisplayEntity(pBlockEntity.getLevel());
        if (entity != null) {
            float f = 0.53125f;
            float f1 = Math.max(entity.getBbWidth(), entity.getBbHeight());
            if ((double)f1 > 1.0) {
                f /= f1;
            }
            pPoseStack.translate(0.0, 0.4f, 0.0);
            pPoseStack.mulPose(Vector3f.YP.rotationDegrees((float)Mth.lerp((double)pPartialTick, basespawner.getoSpin(), basespawner.getSpin()) * 10.0f));
            pPoseStack.translate(0.0, -0.2f, 0.0);
            pPoseStack.mulPose(Vector3f.XP.rotationDegrees(-30.0f));
            pPoseStack.scale(f, f, f);
            Minecraft.getInstance().getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, pPartialTick, pPoseStack, pBufferSource, pPackedLight);
        }
        pPoseStack.popPose();
    }
}

