/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;

public class StructureBlockRenderer
implements BlockEntityRenderer<StructureBlockEntity> {
    public StructureBlockRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    @Override
    public void render(StructureBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (Minecraft.getInstance().player.canUseGameMasterBlocks() || Minecraft.getInstance().player.isSpectator()) {
            BlockPos blockpos = pBlockEntity.getStructurePos();
            Vec3i vec3i = pBlockEntity.getStructureSize();
            if (vec3i.getX() >= 1 && vec3i.getY() >= 1 && vec3i.getZ() >= 1 && (pBlockEntity.getMode() == StructureMode.SAVE || pBlockEntity.getMode() == StructureMode.LOAD)) {
                double d7;
                double d6;
                double d4;
                double d2;
                double d0 = blockpos.getX();
                double d1 = blockpos.getZ();
                double d5 = blockpos.getY();
                double d8 = d5 + (double)vec3i.getY();
                double d3 = switch (pBlockEntity.getMirror()) {
                    case Mirror.LEFT_RIGHT -> {
                        d2 = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        d2 = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        d2 = vec3i.getX();
                        yield vec3i.getZ();
                    }
                };
                double d9 = switch (pBlockEntity.getRotation()) {
                    case Rotation.CLOCKWISE_90 -> {
                        d4 = d3 < 0.0 ? d0 : d0 + 1.0;
                        d6 = d2 < 0.0 ? d1 + 1.0 : d1;
                        d7 = d4 - d3;
                        yield d6 + d2;
                    }
                    case Rotation.CLOCKWISE_180 -> {
                        d4 = d2 < 0.0 ? d0 : d0 + 1.0;
                        d6 = d3 < 0.0 ? d1 : d1 + 1.0;
                        d7 = d4 - d2;
                        yield d6 - d3;
                    }
                    case Rotation.COUNTERCLOCKWISE_90 -> {
                        d4 = d3 < 0.0 ? d0 + 1.0 : d0;
                        d6 = d2 < 0.0 ? d1 : d1 + 1.0;
                        d7 = d4 + d3;
                        yield d6 - d2;
                    }
                    default -> {
                        d4 = d2 < 0.0 ? d0 + 1.0 : d0;
                        d6 = d3 < 0.0 ? d1 + 1.0 : d1;
                        d7 = d4 + d2;
                        yield d6 + d3;
                    }
                };
                float f = 1.0f;
                float f1 = 0.9f;
                float f2 = 0.5f;
                VertexConsumer vertexconsumer = pBufferSource.getBuffer(RenderType.lines());
                if (pBlockEntity.getMode() == StructureMode.SAVE || pBlockEntity.getShowBoundingBox()) {
                    LevelRenderer.renderLineBox(pPoseStack, vertexconsumer, d4, d5, d6, d7, d8, d9, 0.9f, 0.9f, 0.9f, 1.0f, 0.5f, 0.5f, 0.5f);
                }
                if (pBlockEntity.getMode() == StructureMode.SAVE && pBlockEntity.getShowAir()) {
                    this.renderInvisibleBlocks(pBlockEntity, vertexconsumer, blockpos, pPoseStack);
                }
            }
        }
    }

    private void renderInvisibleBlocks(StructureBlockEntity pBlockEntity, VertexConsumer pConsumer, BlockPos pPos, PoseStack pPoseStack) {
        Level blockgetter = pBlockEntity.getLevel();
        BlockPos blockpos = pBlockEntity.getBlockPos();
        BlockPos blockpos1 = blockpos.offset(pPos);
        for (BlockPos blockpos2 : BlockPos.betweenClosed(blockpos1, blockpos1.offset(pBlockEntity.getStructureSize()).offset(-1, -1, -1))) {
            boolean flag4;
            BlockState blockstate = blockgetter.getBlockState(blockpos2);
            boolean flag = blockstate.isAir();
            boolean flag1 = blockstate.is(Blocks.STRUCTURE_VOID);
            boolean flag2 = blockstate.is(Blocks.BARRIER);
            boolean flag3 = blockstate.is(Blocks.LIGHT);
            boolean bl = flag4 = flag1 || flag2 || flag3;
            if (!flag && !flag4) continue;
            float f = flag ? 0.05f : 0.0f;
            double d0 = (float)(blockpos2.getX() - blockpos.getX()) + 0.45f - f;
            double d1 = (float)(blockpos2.getY() - blockpos.getY()) + 0.45f - f;
            double d2 = (float)(blockpos2.getZ() - blockpos.getZ()) + 0.45f - f;
            double d3 = (float)(blockpos2.getX() - blockpos.getX()) + 0.55f + f;
            double d4 = (float)(blockpos2.getY() - blockpos.getY()) + 0.55f + f;
            double d5 = (float)(blockpos2.getZ() - blockpos.getZ()) + 0.55f + f;
            if (flag) {
                LevelRenderer.renderLineBox(pPoseStack, pConsumer, d0, d1, d2, d3, d4, d5, 0.5f, 0.5f, 1.0f, 1.0f, 0.5f, 0.5f, 1.0f);
                continue;
            }
            if (flag1) {
                LevelRenderer.renderLineBox(pPoseStack, pConsumer, d0, d1, d2, d3, d4, d5, 1.0f, 0.75f, 0.75f, 1.0f, 1.0f, 0.75f, 0.75f);
                continue;
            }
            if (flag2) {
                LevelRenderer.renderLineBox(pPoseStack, pConsumer, d0, d1, d2, d3, d4, d5, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f);
                continue;
            }
            if (!flag3) continue;
            LevelRenderer.renderLineBox(pPoseStack, pConsumer, d0, d1, d2, d3, d4, d5, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public boolean shouldRenderOffScreen(StructureBlockEntity pBlockEntity) {
        return true;
    }

    @Override
    public int getViewDistance() {
        return 96;
    }
}

