/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomBlockLayers;
import net.optifine.override.ChunkCacheOF;
import net.optifine.reflect.Reflector;
import net.optifine.render.AabbFrame;
import net.optifine.render.ChunkLayerMap;
import net.optifine.render.ChunkLayerSet;
import net.optifine.render.ICamera;
import net.optifine.render.RenderEnv;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.util.ChunkUtils;
import org.slf4j.Logger;

public class ChunkRenderDispatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_WORKERS_32_BIT = 4;
    private static final VertexFormat VERTEX_FORMAT = DefaultVertexFormat.BLOCK;
    private static final int MAX_HIGH_PRIORITY_QUOTA = 2;
    private final PriorityBlockingQueue<RenderChunk.ChunkCompileTask> toBatchHighPriority;
    private final Queue<RenderChunk.ChunkCompileTask> toBatchLowPriority;
    private int highPriorityQuota;
    private final Queue<ChunkBufferBuilderPack> freeBuffers;
    private final Queue<Runnable> toUpload;
    private volatile int toBatchCount;
    private volatile int freeBufferCount;
    final ChunkBufferBuilderPack fixedBuffers;
    private final ProcessorMailbox<Runnable> mailbox;
    private final Executor executor;
    ClientLevel level;
    final LevelRenderer renderer;
    private Vec3 camera;
    private int countRenderBuilders;
    private List<ChunkBufferBuilderPack> listPausedBuilders;
    public static final RenderType[] BLOCK_RENDER_LAYERS = RenderType.chunkBufferLayers().toArray(new RenderType[0]);
    private static final boolean FORGE = Reflector.ForgeHooksClient.exists();
    private static final boolean FORGE_CAN_RENDER_IN_LAYER_BS = Reflector.ForgeRenderTypeLookup_canRenderInLayerBs.exists();
    private static final boolean FORGE_CAN_RENDER_IN_LAYER_FS = Reflector.ForgeRenderTypeLookup_canRenderInLayerBs.exists();
    private static final boolean FORGE_SET_RENDER_TYPE = Reflector.ForgeHooksClient_setRenderType.exists();
    public static int renderChunksUpdated;

    public ChunkRenderDispatcher(ClientLevel p_194405_, LevelRenderer p_194406_, Executor p_194407_, boolean p_194408_, ChunkBufferBuilderPack p_194409_) {
        this(p_194405_, p_194406_, p_194407_, p_194408_, p_194409_, -1);
    }

    /*
     * Unable to fully structure code
     */
    public ChunkRenderDispatcher(ClientLevel worldIn, LevelRenderer worldRendererIn, Executor executorIn, boolean java64bit, ChunkBufferBuilderPack fixedBuilderIn, int countRenderBuildersIn) {
        block5: {
            super();
            this.toBatchHighPriority = Queues.newPriorityBlockingQueue();
            this.toBatchLowPriority = Queues.newLinkedBlockingDeque();
            this.highPriorityQuota = 2;
            this.toUpload = Queues.newConcurrentLinkedQueue();
            this.camera = Vec3.ZERO;
            this.listPausedBuilders = new ArrayList<ChunkBufferBuilderPack>();
            this.level = worldIn;
            this.renderer = worldRendererIn;
            i = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.chunkBufferLayers().stream().mapToInt((ToIntFunction<RenderType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, bufferSize(), (Lnet/minecraft/client/renderer/RenderType;)I)()).sum() * 4) - 1);
            j = Runtime.getRuntime().availableProcessors();
            k = java64bit != false ? j : Math.min(j, 4);
            l = Math.max(1, Math.min(k, i));
            if (countRenderBuildersIn > 0) {
                l = countRenderBuildersIn;
            }
            this.fixedBuffers = fixedBuilderIn;
            list = Lists.newArrayListWithExpectedSize((int)l);
            try {
                i1 = 0;
                while (i1 < l) {
                    list.add(new ChunkBufferBuilderPack());
                    ++i1;
                }
                break block5;
            }
            catch (OutOfMemoryError outofmemoryerror1) {
                ChunkRenderDispatcher.LOGGER.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)l);
                j1 = Math.min(list.size() * 2 / 3, list.size() - 1);
                k1 = 0;
                ** while (k1 < j1)
            }
lbl-1000:
            // 1 sources

            {
                list.remove(list.size() - 1);
                ++k1;
                continue;
            }
lbl35:
            // 1 sources

            System.gc();
        }
        this.freeBuffers = Queues.newConcurrentLinkedQueue((Iterable)list);
        this.countRenderBuilders = this.freeBufferCount = this.freeBuffers.size();
        this.executor = executorIn;
        this.mailbox = ProcessorMailbox.create(executorIn, "Chunk Renderer");
        this.mailbox.tell((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, runTask(), ()V)((ChunkRenderDispatcher)this));
    }

    public void setLevel(ClientLevel p_194411_) {
        this.level = p_194411_;
    }

    private void runTask() {
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask;
        if (!this.freeBuffers.isEmpty() && (chunkrenderdispatcher$renderchunk$chunkcompiletask = this.pollTask()) != null) {
            ChunkBufferBuilderPack chunkbufferbuilderpack = this.freeBuffers.poll();
            if (chunkbufferbuilderpack == null) {
                this.toBatchHighPriority.add(chunkrenderdispatcher$renderchunk$chunkcompiletask);
                return;
            }
            this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
            this.freeBufferCount = this.freeBuffers.size();
            ((CompletableFuture)CompletableFuture.supplyAsync(Util.wrapThreadWithTaskName(chunkrenderdispatcher$renderchunk$chunkcompiletask.name(), () -> chunkrenderdispatcher$renderchunk$chunkcompiletask.doTask(chunkbufferbuilderpack)), this.executor).thenCompose(p_194415_0_ -> p_194415_0_)).whenComplete((taskResultIn, throwableIn) -> {
                if (throwableIn != null) {
                    CrashReport crashreport = CrashReport.forThrowable(throwableIn, "Batching chunks");
                    Minecraft.getInstance().delayCrash(() -> Minecraft.getInstance().fillReport(crashreport));
                } else {
                    this.mailbox.tell(() -> {
                        if (taskResultIn == ChunkTaskResult.SUCCESSFUL) {
                            chunkbufferbuilderpack.clearAll();
                        } else {
                            chunkbufferbuilderpack.discardAll();
                        }
                        this.freeBuffers.add(chunkbufferbuilderpack);
                        this.freeBufferCount = this.freeBuffers.size();
                        this.runTask();
                    });
                }
            });
        }
    }

    @Nullable
    private RenderChunk.ChunkCompileTask pollTask() {
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask;
        if (this.highPriorityQuota <= 0 && (chunkrenderdispatcher$renderchunk$chunkcompiletask = this.toBatchLowPriority.poll()) != null) {
            this.highPriorityQuota = 2;
            return chunkrenderdispatcher$renderchunk$chunkcompiletask;
        }
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask1 = this.toBatchHighPriority.poll();
        if (chunkrenderdispatcher$renderchunk$chunkcompiletask1 != null) {
            --this.highPriorityQuota;
            return chunkrenderdispatcher$renderchunk$chunkcompiletask1;
        }
        this.highPriorityQuota = 2;
        return this.toBatchLowPriority.poll();
    }

    public String getStats() {
        return String.format("pC: %03d, pU: %02d, aB: %02d", this.toBatchCount, this.toUpload.size(), this.freeBufferCount);
    }

    public int getToBatchCount() {
        return this.toBatchCount;
    }

    public int getToUpload() {
        return this.toUpload.size();
    }

    public int getFreeBufferCount() {
        return this.freeBufferCount;
    }

    public void setCamera(Vec3 pCamera) {
        this.camera = pCamera;
    }

    public Vec3 getCameraPosition() {
        return this.camera;
    }

    public void uploadAllPendingUploads() {
        Runnable runnable;
        while ((runnable = this.toUpload.poll()) != null) {
            runnable.run();
        }
    }

    public void rebuildChunkSync(RenderChunk p_200432_, RenderRegionCache p_200433_) {
        p_200432_.compileSync(p_200433_);
    }

    public void blockUntilClear() {
        this.clearBatchQueue();
    }

    public void schedule(RenderChunk.ChunkCompileTask pTask) {
        this.mailbox.tell(() -> {
            if (chunkCompileTask.isHighPriority) {
                this.toBatchHighPriority.offer(pTask);
            } else {
                this.toBatchLowPriority.offer(pTask);
            }
            this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
            this.runTask();
        });
    }

    public CompletableFuture<Void> uploadChunkLayer(BufferBuilder pBuilder, VertexBuffer pBuffer) {
        return CompletableFuture.runAsync(() -> {}, this.toUpload::add).thenCompose(voidIn -> this.doUploadChunkLayer(pBuilder, pBuffer));
    }

    private CompletableFuture<Void> doUploadChunkLayer(BufferBuilder pBuilder, VertexBuffer pBuffer) {
        return pBuffer.uploadLater(pBuilder);
    }

    private void clearBatchQueue() {
        while (!this.toBatchHighPriority.isEmpty()) {
            RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.toBatchHighPriority.poll();
            if (chunkrenderdispatcher$renderchunk$chunkcompiletask == null) continue;
            chunkrenderdispatcher$renderchunk$chunkcompiletask.cancel();
        }
        while (!this.toBatchLowPriority.isEmpty()) {
            RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask1 = this.toBatchLowPriority.poll();
            if (chunkrenderdispatcher$renderchunk$chunkcompiletask1 == null) continue;
            chunkrenderdispatcher$renderchunk$chunkcompiletask1.cancel();
        }
        this.toBatchCount = 0;
    }

    public boolean isQueueEmpty() {
        return this.toBatchCount == 0 && this.toUpload.isEmpty();
    }

    public void dispose() {
        this.clearBatchQueue();
        this.mailbox.close();
        this.freeBuffers.clear();
    }

    public void pauseChunkUpdates() {
        long i = System.currentTimeMillis();
        if (this.listPausedBuilders.size() <= 0) {
            while (this.listPausedBuilders.size() != this.countRenderBuilders) {
                this.uploadAllPendingUploads();
                ChunkBufferBuilderPack chunkbufferbuilderpack = this.freeBuffers.poll();
                if (chunkbufferbuilderpack != null) {
                    this.listPausedBuilders.add(chunkbufferbuilderpack);
                }
                if (System.currentTimeMillis() > i + 1000L) break;
            }
        }
    }

    public void resumeChunkUpdates() {
        this.freeBuffers.addAll(this.listPausedBuilders);
        this.listPausedBuilders.clear();
    }

    public boolean updateChunkNow(RenderChunk renderChunk, RenderRegionCache regionCacheIn) {
        this.rebuildChunkSync(renderChunk, regionCacheIn);
        return true;
    }

    public boolean updateChunkLater(RenderChunk renderChunk, RenderRegionCache regionCacheIn) {
        if (this.freeBuffers.isEmpty()) {
            return false;
        }
        renderChunk.rebuildChunkAsync(this, regionCacheIn);
        return true;
    }

    public boolean updateTransparencyLater(RenderChunk renderChunk) {
        return this.freeBuffers.isEmpty() ? false : renderChunk.resortTransparency(RenderTypes.TRANSLUCENT, this);
    }

    static enum ChunkTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }

    public static class CompiledChunk {
        public static final CompiledChunk UNCOMPILED = new CompiledChunk(){

            @Override
            public boolean facesCanSeeEachother(Direction p_112782_, Direction p_112783_) {
                return false;
            }

            @Override
            public void setAnimatedSprites(RenderType layer, BitSet animatedSprites) {
                throw new UnsupportedOperationException();
            }
        };
        final Set<RenderType> hasBlocks = new ChunkLayerSet();
        final Set<RenderType> hasLayer = new ObjectArraySet();
        boolean isCompletelyEmpty = true;
        final List<BlockEntity> renderableBlockEntities = Lists.newArrayList();
        VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        BufferBuilder.SortState transparencyState;
        private BitSet[] animatedSprites = new BitSet[RenderType.CHUNK_RENDER_TYPES.length];

        public boolean hasNoRenderableLayers() {
            return this.isCompletelyEmpty;
        }

        public boolean isEmpty(RenderType pRenderType) {
            return !this.hasBlocks.contains(pRenderType);
        }

        public List<BlockEntity> getRenderableBlockEntities() {
            return this.renderableBlockEntities;
        }

        public boolean facesCanSeeEachother(Direction pFace, Direction pOtherFace) {
            return this.visibilitySet.visibilityBetween(pFace, pOtherFace);
        }

        public BitSet getAnimatedSprites(RenderType layer) {
            return this.animatedSprites[layer.ordinal()];
        }

        public void setAnimatedSprites(RenderType layer, BitSet animatedSprites) {
            this.animatedSprites[layer.ordinal()] = animatedSprites;
        }

        public boolean isLayerStarted(RenderType renderTypeIn) {
            return this.hasLayer.contains(renderTypeIn);
        }

        public void setLayerStarted(RenderType renderTypeIn) {
            this.hasLayer.add(renderTypeIn);
        }

        public void setLayerUsed(RenderType renderTypeIn) {
            this.hasBlocks.add(renderTypeIn);
        }

        public boolean hasTerrainBlockEntities() {
            return !this.hasNoRenderableLayers() || !this.getRenderableBlockEntities().isEmpty();
        }
    }

    public class RenderChunk {
        public static final int SIZE = 16;
        public final int index;
        public final AtomicReference<CompiledChunk> compiled = new AtomicReference<CompiledChunk>(CompiledChunk.UNCOMPILED);
        final AtomicInteger initialCompilationCancelCount = new AtomicInteger(0);
        @Nullable
        private RebuildTask lastRebuildTask;
        @Nullable
        private ResortTransparencyTask lastResortTransparencyTask;
        private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
        private final ChunkLayerMap<VertexBuffer> buffers = new ChunkLayerMap<VertexBuffer>(renderType -> new VertexBuffer());
        private AABB bb;
        private boolean dirty = true;
        final BlockPos.MutableBlockPos origin = new BlockPos.MutableBlockPos(-1, -1, -1);
        private final BlockPos.MutableBlockPos[] relativeOrigins = Util.make(new BlockPos.MutableBlockPos[6], posArrIn -> {
            int i = 0;
            while (i < ((BlockPos.MutableBlockPos[])posArrIn).length) {
                posArrIn[i] = new BlockPos.MutableBlockPos();
                ++i;
            }
        });
        private boolean playerChanged;
        private final boolean isMipmaps = Config.isMipmaps();
        private final boolean fixBlockLayer = !Reflector.BetterFoliageClient.exists();
        private boolean playerUpdate = false;
        private boolean needsBackgroundPriorityUpdate;
        private boolean renderRegions = Config.isRenderRegions();
        public int regionX;
        public int regionZ;
        public int regionDX;
        public int regionDY;
        public int regionDZ;
        private final RenderChunk[] renderChunksOfset16 = new RenderChunk[6];
        private boolean renderChunksOffset16Updated = false;
        private LevelChunk chunk;
        private RenderChunk[] renderChunkNeighbours = new RenderChunk[Direction.VALUES.length];
        private RenderChunk[] renderChunkNeighboursValid = new RenderChunk[Direction.VALUES.length];
        private boolean renderChunkNeighboursUpated = false;
        private LevelRenderer.RenderChunkInfo renderInfo = new LevelRenderer.RenderChunkInfo(this, null, 0);
        public AabbFrame boundingBoxParent;

        public RenderChunk(int p_202436_, int p_202437_, int p_202438_, int p_202439_) {
            this.index = p_202436_;
            this.setOrigin(p_202437_, p_202438_, p_202439_);
        }

        private boolean doesChunkExistAt(BlockPos pPos) {
            return ChunkRenderDispatcher.this.level.getChunk(SectionPos.blockToSectionCoord(pPos.getX()), SectionPos.blockToSectionCoord(pPos.getZ()), ChunkStatus.FULL, false) != null;
        }

        public boolean hasAllNeighbors() {
            int i = 24;
            return !(this.getDistToPlayerSqr() > 576.0) ? true : this.doesChunkExistAt(this.origin);
        }

        public AABB getBoundingBox() {
            return this.bb;
        }

        public VertexBuffer getBuffer(RenderType pRenderType) {
            return this.buffers.get(pRenderType);
        }

        public void setOrigin(int pX, int pY, int pZ) {
            this.reset();
            this.origin.set(pX, pY, pZ);
            if (this.renderRegions) {
                int i = 8;
                this.regionX = pX >> i << i;
                this.regionZ = pZ >> i << i;
                this.regionDX = pX - this.regionX;
                this.regionDY = pY;
                this.regionDZ = pZ - this.regionZ;
            }
            this.bb = new AABB(pX, pY, pZ, pX + 16, pY + 16, pZ + 16);
            Direction[] directionArray = Direction.VALUES;
            int n = Direction.VALUES.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                this.relativeOrigins[direction.ordinal()].set(this.origin).move(direction, 16);
                ++n2;
            }
            this.renderChunksOffset16Updated = false;
            this.renderChunkNeighboursUpated = false;
            int j = 0;
            while (j < this.renderChunkNeighbours.length) {
                RenderChunk chunkrenderdispatcher$renderchunk = this.renderChunkNeighbours[j];
                if (chunkrenderdispatcher$renderchunk != null) {
                    chunkrenderdispatcher$renderchunk.renderChunkNeighboursUpated = false;
                }
                ++j;
            }
            this.chunk = null;
            this.boundingBoxParent = null;
        }

        protected double getDistToPlayerSqr() {
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            double d0 = this.bb.minX + 8.0 - camera.getPosition().x;
            double d1 = this.bb.minY + 8.0 - camera.getPosition().y;
            double d2 = this.bb.minZ + 8.0 - camera.getPosition().z;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        void beginLayer(BufferBuilder pBuilder) {
            pBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        }

        public CompiledChunk getCompiledChunk() {
            return this.compiled.get();
        }

        private void reset() {
            this.cancelTasks();
            this.compiled.set(CompiledChunk.UNCOMPILED);
            this.dirty = true;
        }

        public void releaseBuffers() {
            this.reset();
            this.buffers.values().forEach(VertexBuffer::close);
        }

        public BlockPos getOrigin() {
            return this.origin;
        }

        public void setDirty(boolean pReRenderOnMainThread) {
            boolean flag = this.dirty;
            this.dirty = true;
            this.playerChanged = pReRenderOnMainThread | (flag && this.playerChanged);
            if (this.isWorldPlayerUpdate()) {
                this.playerUpdate = true;
            }
            if (!flag) {
                ChunkRenderDispatcher.this.renderer.onChunkRenderNeedsUpdate(this);
            }
        }

        public void setNotDirty() {
            this.dirty = false;
            this.playerChanged = false;
            this.playerUpdate = false;
            this.needsBackgroundPriorityUpdate = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public boolean isDirtyFromPlayer() {
            return this.dirty && this.playerChanged;
        }

        public BlockPos getRelativeOrigin(Direction pDirection) {
            return this.relativeOrigins[pDirection.ordinal()];
        }

        public boolean resortTransparency(RenderType pType, ChunkRenderDispatcher pDispatcher) {
            CompiledChunk chunkrenderdispatcher$compiledchunk = this.getCompiledChunk();
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
            }
            if (!chunkrenderdispatcher$compiledchunk.hasLayer.contains(pType)) {
                return false;
            }
            this.lastResortTransparencyTask = FORGE ? new ResortTransparencyTask(new ChunkPos(this.getOrigin()), this.getDistToPlayerSqr(), chunkrenderdispatcher$compiledchunk) : new ResortTransparencyTask(this.getDistToPlayerSqr(), chunkrenderdispatcher$compiledchunk);
            pDispatcher.schedule(this.lastResortTransparencyTask);
            return true;
        }

        protected boolean cancelTasks() {
            boolean flag = false;
            if (this.lastRebuildTask != null) {
                this.lastRebuildTask.cancel();
                this.lastRebuildTask = null;
                flag = true;
            }
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
                this.lastResortTransparencyTask = null;
            }
            return flag;
        }

        public ChunkCompileTask createCompileTask(RenderRegionCache p_200438_) {
            boolean flag1;
            boolean flag = this.cancelTasks();
            BlockPos blockpos = this.origin.immutable();
            boolean i = true;
            RenderChunkRegion renderchunkregion = null;
            boolean bl = flag1 = this.compiled.get() == CompiledChunk.UNCOMPILED;
            if (flag1 && flag) {
                this.initialCompilationCancelCount.incrementAndGet();
            }
            ChunkPos chunkpos = FORGE ? new ChunkPos(this.getOrigin()) : null;
            this.lastRebuildTask = new RebuildTask(chunkpos, this.getDistToPlayerSqr(), renderchunkregion, !flag1 || this.initialCompilationCancelCount.get() > 2);
            return this.lastRebuildTask;
        }

        public void rebuildChunkAsync(ChunkRenderDispatcher p_200435_, RenderRegionCache p_200436_) {
            ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.createCompileTask(p_200436_);
            p_200435_.schedule(chunkrenderdispatcher$renderchunk$chunkcompiletask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateGlobalBlockEntities(Set<BlockEntity> pBlockEntities) {
            HashSet set1;
            HashSet set = Sets.newHashSet(pBlockEntities);
            Set<BlockEntity> set2 = this.globalBlockEntities;
            synchronized (set2) {
                set1 = Sets.newHashSet(this.globalBlockEntities);
                set.removeAll(this.globalBlockEntities);
                set1.removeAll(pBlockEntities);
                this.globalBlockEntities.clear();
                this.globalBlockEntities.addAll(pBlockEntities);
            }
            ChunkRenderDispatcher.this.renderer.updateGlobalBlockEntities(set1, set);
        }

        public void compileSync(RenderRegionCache p_200440_) {
            ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.createCompileTask(p_200440_);
            chunkrenderdispatcher$renderchunk$chunkcompiletask.doTask(ChunkRenderDispatcher.this.fixedBuffers);
        }

        private boolean isWorldPlayerUpdate() {
            if (ChunkRenderDispatcher.this.level instanceof ClientLevel) {
                ClientLevel clientlevel = ChunkRenderDispatcher.this.level;
                return clientlevel.isPlayerUpdate();
            }
            return false;
        }

        public boolean isPlayerUpdate() {
            return this.playerUpdate;
        }

        public void setNeedsBackgroundPriorityUpdate(boolean needsBackgroundPriorityUpdate) {
            this.needsBackgroundPriorityUpdate = needsBackgroundPriorityUpdate;
        }

        public boolean needsBackgroundPriorityUpdate() {
            return this.needsBackgroundPriorityUpdate;
        }

        private RenderType[] getFluidRenderLayers(FluidState fluidState, RenderType[] singleLayer) {
            if (FORGE_CAN_RENDER_IN_LAYER_FS) {
                return BLOCK_RENDER_LAYERS;
            }
            singleLayer[0] = ItemBlockRenderTypes.getRenderLayer(fluidState);
            return singleLayer;
        }

        private RenderType[] getBlockRenderLayers(BlockState blockState, RenderType[] singleLayer) {
            if (FORGE_CAN_RENDER_IN_LAYER_BS) {
                return BLOCK_RENDER_LAYERS;
            }
            singleLayer[0] = ItemBlockRenderTypes.getChunkRenderType(blockState);
            return singleLayer;
        }

        private RenderType fixBlockLayer(BlockGetter worldReader, BlockState blockState, BlockPos blockPos, RenderType layer) {
            RenderType rendertype;
            if (CustomBlockLayers.isActive() && (rendertype = CustomBlockLayers.getRenderLayer(worldReader, blockState, blockPos)) != null) {
                return rendertype;
            }
            if (!this.fixBlockLayer) {
                return layer;
            }
            if (this.isMipmaps) {
                if (layer == RenderTypes.CUTOUT) {
                    Block block = blockState.getBlock();
                    if (block instanceof RedStoneWireBlock) {
                        return layer;
                    }
                    if (block instanceof CactusBlock) {
                        return layer;
                    }
                    return RenderTypes.CUTOUT_MIPPED;
                }
            } else if (layer == RenderTypes.CUTOUT_MIPPED) {
                return RenderTypes.CUTOUT;
            }
            return layer;
        }

        private void postRenderOverlays(ChunkBufferBuilderPack regionRenderCacheBuilder, CompiledChunk compiledChunk) {
            this.postRenderOverlay(RenderTypes.CUTOUT, regionRenderCacheBuilder, compiledChunk);
            this.postRenderOverlay(RenderTypes.CUTOUT_MIPPED, regionRenderCacheBuilder, compiledChunk);
            this.postRenderOverlay(RenderTypes.TRANSLUCENT, regionRenderCacheBuilder, compiledChunk);
        }

        private void postRenderOverlay(RenderType layer, ChunkBufferBuilderPack regionRenderCacheBuilder, CompiledChunk compiledchunk) {
            BufferBuilder bufferbuilder = regionRenderCacheBuilder.builder(layer);
            if (bufferbuilder.building()) {
                compiledchunk.setLayerStarted(layer);
                if (bufferbuilder.getVertexCount() > 0) {
                    compiledchunk.setLayerUsed(layer);
                }
            }
        }

        private ChunkCacheOF makeChunkCacheOF(BlockPos posIn) {
            BlockPos blockpos = posIn.offset(-1, -1, -1);
            BlockPos blockpos1 = posIn.offset(16, 16, 16);
            RenderRegionCache renderregioncache = new RenderRegionCache();
            RenderChunkRegion renderchunkregion = renderregioncache.createRegion(ChunkRenderDispatcher.this.level, blockpos, blockpos1, 1, false);
            return new ChunkCacheOF(renderchunkregion, blockpos, blockpos1, 1);
        }

        public RenderChunk getRenderChunkOffset16(ViewArea viewFrustum, Direction facing) {
            if (!this.renderChunksOffset16Updated) {
                int i = 0;
                while (i < Direction.VALUES.length) {
                    Direction direction = Direction.VALUES[i];
                    BlockPos blockpos = this.getRelativeOrigin(direction);
                    this.renderChunksOfset16[i] = viewFrustum.getRenderChunkAt(blockpos);
                    ++i;
                }
                this.renderChunksOffset16Updated = true;
            }
            return this.renderChunksOfset16[facing.ordinal()];
        }

        public LevelChunk getChunk() {
            return this.getChunk(this.origin);
        }

        private LevelChunk getChunk(BlockPos posIn) {
            LevelChunk levelchunk = this.chunk;
            if (levelchunk != null && ChunkUtils.isLoaded(levelchunk)) {
                return levelchunk;
            }
            this.chunk = levelchunk = ChunkRenderDispatcher.this.level.getChunkAt(posIn);
            return levelchunk;
        }

        public boolean isChunkRegionEmpty() {
            return this.isChunkRegionEmpty(this.origin);
        }

        private boolean isChunkRegionEmpty(BlockPos posIn) {
            int i = posIn.getY();
            int j = i + 15;
            return this.getChunk(posIn).isYSpaceEmpty(i, j);
        }

        public void setRenderChunkNeighbour(Direction facing, RenderChunk neighbour) {
            this.renderChunkNeighbours[facing.ordinal()] = neighbour;
            this.renderChunkNeighboursValid[facing.ordinal()] = neighbour;
        }

        public RenderChunk getRenderChunkNeighbour(Direction facing) {
            if (!this.renderChunkNeighboursUpated) {
                this.updateRenderChunkNeighboursValid();
            }
            return this.renderChunkNeighboursValid[facing.ordinal()];
        }

        public LevelRenderer.RenderChunkInfo getRenderInfo() {
            return this.renderInfo;
        }

        public LevelRenderer.RenderChunkInfo getRenderInfo(Direction dirIn, int counterIn) {
            this.renderInfo.initialize(dirIn, counterIn);
            return this.renderInfo;
        }

        private void updateRenderChunkNeighboursValid() {
            int i = this.getOrigin().getX();
            int j = this.getOrigin().getZ();
            int k = Direction.NORTH.ordinal();
            int l = Direction.SOUTH.ordinal();
            int i1 = Direction.WEST.ordinal();
            int j1 = Direction.EAST.ordinal();
            this.renderChunkNeighboursValid[k] = this.renderChunkNeighbours[k].getOrigin().getZ() == j - 16 ? this.renderChunkNeighbours[k] : null;
            this.renderChunkNeighboursValid[l] = this.renderChunkNeighbours[l].getOrigin().getZ() == j + 16 ? this.renderChunkNeighbours[l] : null;
            this.renderChunkNeighboursValid[i1] = this.renderChunkNeighbours[i1].getOrigin().getX() == i - 16 ? this.renderChunkNeighbours[i1] : null;
            this.renderChunkNeighboursValid[j1] = this.renderChunkNeighbours[j1].getOrigin().getX() == i + 16 ? this.renderChunkNeighbours[j1] : null;
            this.renderChunkNeighboursUpated = true;
        }

        public boolean isBoundingBoxInFrustum(ICamera camera, int frameCount) {
            return this.getBoundingBoxParent().isBoundingBoxInFrustumFully(camera, frameCount) ? true : camera.isBoundingBoxInFrustum(this.bb);
        }

        public AabbFrame getBoundingBoxParent() {
            if (this.boundingBoxParent == null) {
                AabbFrame aabbframe;
                BlockPos blockpos = this.getOrigin();
                int i = blockpos.getX();
                int j = blockpos.getY();
                int k = blockpos.getZ();
                int l = 5;
                int i1 = i >> l << l;
                int j1 = j >> l << l;
                int k1 = k >> l << l;
                if ((i1 != i || j1 != j || k1 != k) && (aabbframe = ChunkRenderDispatcher.this.renderer.getRenderChunk(new BlockPos(i1, j1, k1)).getBoundingBoxParent()) != null && aabbframe.minX == (double)i1 && aabbframe.minY == (double)j1 && aabbframe.minZ == (double)k1) {
                    this.boundingBoxParent = aabbframe;
                }
                if (this.boundingBoxParent == null) {
                    int l1 = 1 << l;
                    this.boundingBoxParent = new AabbFrame(i1, j1, k1, i1 + l1, j1 + l1, k1 + l1);
                }
            }
            return this.boundingBoxParent;
        }

        public ClientLevel getWorld() {
            return ChunkRenderDispatcher.this.level;
        }

        public String toString() {
            return "pos: " + this.getOrigin();
        }

        abstract class ChunkCompileTask
        implements Comparable<ChunkCompileTask> {
            protected final double distAtCreation;
            protected final AtomicBoolean isCancelled = new AtomicBoolean(false);
            protected final boolean isHighPriority;
            protected Map<BlockPos, IModelData> modelData;

            public ChunkCompileTask(double p_194423_, boolean p_194424_) {
                this(null, p_194423_, p_194424_);
            }

            public ChunkCompileTask(ChunkPos pos, double distanceSqIn, boolean highPriorityIn) {
                this.distAtCreation = distanceSqIn;
                this.isHighPriority = highPriorityIn;
                this.modelData = pos == null ? Collections.emptyMap() : ModelDataManager.getModelData(Minecraft.getInstance().level, pos);
            }

            public abstract CompletableFuture<ChunkTaskResult> doTask(ChunkBufferBuilderPack var1);

            public abstract void cancel();

            protected abstract String name();

            @Override
            public int compareTo(ChunkCompileTask pOther) {
                return Doubles.compare((double)this.distAtCreation, (double)pOther.distAtCreation);
            }

            public IModelData getModelData(BlockPos pos) {
                return this.modelData.getOrDefault(pos, EmptyModelData.INSTANCE);
            }
        }

        class RebuildTask
        extends ChunkCompileTask {
            @Nullable
            protected RenderChunkRegion region;

            public RebuildTask(double p_194427_, RenderChunkRegion p_194428_, boolean p_194429_) {
                this(null, p_194427_, p_194428_, p_194429_);
            }

            public RebuildTask(@Nullable ChunkPos pos, double distanceSqIn, RenderChunkRegion renderCacheIn, boolean highPriorityIn) {
                super(pos, distanceSqIn, highPriorityIn);
                this.region = renderCacheIn;
            }

            @Override
            protected String name() {
                return "rend_chk_rebuild";
            }

            @Override
            public CompletableFuture<ChunkTaskResult> doTask(ChunkBufferBuilderPack pBuffers) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!RenderChunk.this.hasAllNeighbors()) {
                    this.region = null;
                    RenderChunk.this.setDirty(false);
                    this.isCancelled.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vec3 vec3 = ChunkRenderDispatcher.this.getCameraPosition();
                float f = (float)vec3.x;
                float f1 = (float)vec3.y;
                float f2 = (float)vec3.z;
                CompiledChunk chunkrenderdispatcher$compiledchunk = new CompiledChunk();
                Set<BlockEntity> set = this.compile(f, f1, f2, chunkrenderdispatcher$compiledchunk, pBuffers);
                RenderChunk.this.updateGlobalBlockEntities(set);
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                ArrayList list = Lists.newArrayList();
                chunkrenderdispatcher$compiledchunk.hasLayer.forEach(renderTypeIn -> list.add(ChunkRenderDispatcher.this.uploadChunkLayer(pBuffers.builder((RenderType)renderTypeIn), RenderChunk.this.getBuffer((RenderType)renderTypeIn))));
                return Util.sequenceFailFast(list).handle((listIn, throwableIn) -> {
                    if (throwableIn != null && !(throwableIn instanceof CancellationException) && !(throwableIn instanceof InterruptedException)) {
                        CrashReport crashreport = CrashReport.forThrowable(throwableIn, "Rendering chunk");
                        Minecraft.getInstance().delayCrash(() -> crashreport);
                    }
                    if (this.isCancelled.get()) {
                        return ChunkTaskResult.CANCELLED;
                    }
                    RenderChunk.this.compiled.set(chunkrenderdispatcher$compiledchunk);
                    RenderChunk.this.initialCompilationCancelCount.set(0);
                    ((RenderChunk)RenderChunk.this).ChunkRenderDispatcher.this.renderer.addRecentlyCompiledChunk(RenderChunk.this);
                    return ChunkTaskResult.SUCCESSFUL;
                });
            }

            private Set<BlockEntity> compile(float pX, float pY, float pZ, CompiledChunk pCompiledChunk, ChunkBufferBuilderPack pBuffers) {
                boolean i = true;
                BlockPos blockpos = RenderChunk.this.origin.immutable();
                BlockPos blockpos1 = blockpos.offset(15, 15, 15);
                VisGraph visgraph = new VisGraph();
                HashSet set = Sets.newHashSet();
                this.region = null;
                PoseStack posestack = new PoseStack();
                if (!RenderChunk.this.isChunkRegionEmpty(blockpos)) {
                    ++renderChunksUpdated;
                    ChunkCacheOF chunkcacheof = RenderChunk.this.makeChunkCacheOF(blockpos);
                    chunkcacheof.renderStart();
                    RenderType[] arendertype = new RenderType[1];
                    boolean flag = Config.isShaders();
                    boolean flag1 = flag && Shaders.useMidBlockAttrib;
                    ModelBlockRenderer.enableCaching();
                    Random random = new Random();
                    BlockRenderDispatcher blockrenderdispatcher = Minecraft.getInstance().getBlockRenderer();
                    for (BlockPosM blockposm : BlockPosM.getAllInBoxMutable(blockpos, blockpos1)) {
                        IModelData imodeldata;
                        BlockEntity blockentity;
                        BlockState blockstate = chunkcacheof.getBlockState(blockposm);
                        if (blockstate.isAir()) continue;
                        if (blockstate.isSolidRender(chunkcacheof, blockposm)) {
                            visgraph.setOpaque(blockposm);
                        }
                        if (blockstate.hasBlockEntity() && (blockentity = chunkcacheof.getBlockEntity(blockposm)) != null) {
                            this.handleBlockEntity(pCompiledChunk, set, blockentity);
                        }
                        FluidState fluidstate = blockstate.getFluidState();
                        IModelData iModelData = imodeldata = FORGE ? this.getModelData(blockposm) : null;
                        if (!fluidstate.isEmpty()) {
                            RenderType[] arendertype1 = RenderChunk.this.getFluidRenderLayers(fluidstate, arendertype);
                            int j = 0;
                            while (j < arendertype1.length) {
                                RenderType rendertype = arendertype1[j];
                                if (!FORGE_CAN_RENDER_IN_LAYER_FS || Reflector.callBoolean(Reflector.ForgeRenderTypeLookup_canRenderInLayerFs, fluidstate, rendertype)) {
                                    if (FORGE_SET_RENDER_TYPE) {
                                        Reflector.callVoid(Reflector.ForgeHooksClient_setRenderType, rendertype);
                                    }
                                    BufferBuilder bufferbuilder = pBuffers.builder(rendertype);
                                    bufferbuilder.setBlockLayer(rendertype);
                                    RenderEnv renderenv = bufferbuilder.getRenderEnv(blockstate, blockposm);
                                    renderenv.setRegionRenderCacheBuilder(pBuffers);
                                    chunkcacheof.setRenderEnv(renderenv);
                                    if (pCompiledChunk.hasLayer.add(rendertype)) {
                                        RenderChunk.this.beginLayer(bufferbuilder);
                                    }
                                    if (blockrenderdispatcher.renderLiquid(blockposm, chunkcacheof, bufferbuilder, blockstate, fluidstate)) {
                                        pCompiledChunk.isCompletelyEmpty = false;
                                        pCompiledChunk.hasBlocks.add(rendertype);
                                    }
                                }
                                ++j;
                            }
                        }
                        if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                            RenderType[] arendertype2 = RenderChunk.this.getBlockRenderLayers(blockstate, arendertype);
                            int k = 0;
                            while (k < arendertype2.length) {
                                RenderType rendertype3 = arendertype2[k];
                                if (!FORGE_CAN_RENDER_IN_LAYER_BS || Reflector.callBoolean(Reflector.ForgeRenderTypeLookup_canRenderInLayerBs, blockstate, rendertype3)) {
                                    if (FORGE_SET_RENDER_TYPE) {
                                        Reflector.callVoid(Reflector.ForgeHooksClient_setRenderType, rendertype3);
                                    }
                                    rendertype3 = RenderChunk.this.fixBlockLayer(chunkcacheof, blockstate, blockposm, rendertype3);
                                    BufferBuilder bufferbuilder3 = pBuffers.builder(rendertype3);
                                    bufferbuilder3.setBlockLayer(rendertype3);
                                    RenderEnv renderenv1 = bufferbuilder3.getRenderEnv(blockstate, blockposm);
                                    renderenv1.setRegionRenderCacheBuilder(pBuffers);
                                    chunkcacheof.setRenderEnv(renderenv1);
                                    if (pCompiledChunk.hasLayer.add(rendertype3)) {
                                        RenderChunk.this.beginLayer(bufferbuilder3);
                                    }
                                    posestack.pushPose();
                                    posestack.translate((double)RenderChunk.this.regionDX + (double)(blockposm.getX() & 0xF), (double)RenderChunk.this.regionDY + (double)(blockposm.getY() & 0xF), (double)RenderChunk.this.regionDZ + (double)(blockposm.getZ() & 0xF));
                                    if (flag1) {
                                        bufferbuilder3.setMidBlock(0.5f + (float)RenderChunk.this.regionDX + (float)(blockposm.getX() & 0xF), 0.5f + (float)RenderChunk.this.regionDY + (float)(blockposm.getY() & 0xF), 0.5f + (float)RenderChunk.this.regionDZ + (float)(blockposm.getZ() & 0xF));
                                    }
                                    if (blockrenderdispatcher.renderBatched(blockstate, blockposm, chunkcacheof, posestack, bufferbuilder3, true, random, imodeldata)) {
                                        pCompiledChunk.isCompletelyEmpty = false;
                                        pCompiledChunk.hasBlocks.add(rendertype3);
                                        if (renderenv1.isOverlaysRendered()) {
                                            RenderChunk.this.postRenderOverlays(pBuffers, pCompiledChunk);
                                            renderenv1.setOverlaysRendered(false);
                                        }
                                    }
                                    posestack.popPose();
                                }
                                ++k;
                            }
                        }
                        if (!FORGE_SET_RENDER_TYPE) continue;
                        Reflector.callVoid(Reflector.ForgeHooksClient_setRenderType, null);
                    }
                    if (pCompiledChunk.hasBlocks.contains(RenderType.translucent())) {
                        BufferBuilder bufferbuilder1 = pBuffers.builder(RenderType.translucent());
                        bufferbuilder1.setQuadSortOrigin((float)RenderChunk.this.regionDX + pX - (float)blockpos.getX(), (float)RenderChunk.this.regionDY + pY - (float)blockpos.getY(), (float)RenderChunk.this.regionDZ + pZ - (float)blockpos.getZ());
                        pCompiledChunk.transparencyState = bufferbuilder1.getSortState();
                    }
                    pCompiledChunk.hasLayer.stream().map(pBuffers::builder).forEach(BufferBuilder::end);
                    RenderType[] renderTypeArray = BLOCK_RENDER_LAYERS;
                    int fluidstate = BLOCK_RENDER_LAYERS.length;
                    int n = 0;
                    while (n < fluidstate) {
                        RenderType rendertype2 = renderTypeArray[n];
                        pCompiledChunk.setAnimatedSprites(rendertype2, null);
                        ++n;
                    }
                    for (RenderType rendertype1 : pCompiledChunk.hasLayer) {
                        if (Config.isShaders()) {
                            SVertexBuilder.calcNormalChunkLayer(pBuffers.builder(rendertype1));
                        }
                        BufferBuilder bufferbuilder2 = pBuffers.builder(rendertype1);
                        if (bufferbuilder2.animatedSprites == null || bufferbuilder2.animatedSprites.isEmpty()) continue;
                        pCompiledChunk.setAnimatedSprites(rendertype1, (BitSet)bufferbuilder2.animatedSprites.clone());
                    }
                    chunkcacheof.renderFinish();
                    ModelBlockRenderer.clearCache();
                }
                pCompiledChunk.visibilitySet = visgraph.resolve();
                return set;
            }

            private <E extends BlockEntity> void handleBlockEntity(CompiledChunk pCompiledChunk, Set<BlockEntity> pOffScreenBlockEntitiesToRender, E pBlockEntity) {
                BlockEntityRenderer<E> blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(pBlockEntity);
                if (blockentityrenderer != null) {
                    if (blockentityrenderer.shouldRenderOffScreen(pBlockEntity)) {
                        pOffScreenBlockEntitiesToRender.add(pBlockEntity);
                    } else {
                        pCompiledChunk.renderableBlockEntities.add(pBlockEntity);
                    }
                }
            }

            @Override
            public void cancel() {
                this.region = null;
                if (this.isCancelled.compareAndSet(false, true)) {
                    RenderChunk.this.setDirty(false);
                }
            }
        }

        class ResortTransparencyTask
        extends ChunkCompileTask {
            private final CompiledChunk compiledChunk;

            public ResortTransparencyTask(double p_112889_, CompiledChunk p_112890_) {
                this(null, p_112889_, p_112890_);
            }

            public ResortTransparencyTask(ChunkPos pos, double distanceSqIn, CompiledChunk compiledChunkIn) {
                super(pos, distanceSqIn, true);
                this.compiledChunk = compiledChunkIn;
            }

            @Override
            protected String name() {
                return "rend_chk_sort";
            }

            @Override
            public CompletableFuture<ChunkTaskResult> doTask(ChunkBufferBuilderPack pBuffers) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!RenderChunk.this.hasAllNeighbors()) {
                    this.isCancelled.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vec3 vec3 = ChunkRenderDispatcher.this.getCameraPosition();
                float f = (float)vec3.x;
                float f1 = (float)vec3.y;
                float f2 = (float)vec3.z;
                BufferBuilder.SortState bufferbuilder$sortstate = this.compiledChunk.transparencyState;
                if (bufferbuilder$sortstate != null && this.compiledChunk.hasBlocks.contains(RenderType.translucent())) {
                    BufferBuilder bufferbuilder = pBuffers.builder(RenderType.translucent());
                    bufferbuilder.setBlockLayer(RenderType.translucent());
                    RenderChunk.this.beginLayer(bufferbuilder);
                    bufferbuilder.restoreSortState(bufferbuilder$sortstate);
                    bufferbuilder.setQuadSortOrigin((float)RenderChunk.this.regionDX + f - (float)RenderChunk.this.origin.getX(), (float)RenderChunk.this.regionDY + f1 - (float)RenderChunk.this.origin.getY(), (float)RenderChunk.this.regionDZ + f2 - (float)RenderChunk.this.origin.getZ());
                    this.compiledChunk.transparencyState = bufferbuilder.getSortState();
                    bufferbuilder.end();
                    if (this.isCancelled.get()) {
                        return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                    }
                    CompletionStage completablefuture = ChunkRenderDispatcher.this.uploadChunkLayer(pBuffers.builder(RenderType.translucent()), RenderChunk.this.getBuffer(RenderType.translucent())).thenApply(voidIn -> ChunkTaskResult.CANCELLED);
                    return ((CompletableFuture)completablefuture).handle((taskResultIn, throwableIn) -> {
                        if (throwableIn != null && !(throwableIn instanceof CancellationException) && !(throwableIn instanceof InterruptedException)) {
                            CrashReport crashreport = CrashReport.forThrowable(throwableIn, "Rendering chunk");
                            Minecraft.getInstance().delayCrash(() -> crashreport);
                        }
                        return this.isCancelled.get() ? ChunkTaskResult.CANCELLED : ChunkTaskResult.SUCCESSFUL;
                    });
                }
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }

            @Override
            public void cancel() {
                this.isCancelled.set(true);
            }
        }
    }
}

