/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class VisGraph {
    private static final int SIZE_IN_BITS = 4;
    private static final int LEN = 16;
    private static final int MASK = 15;
    private static final int SIZE = 4096;
    private static final int X_SHIFT = 0;
    private static final int Z_SHIFT = 4;
    private static final int Y_SHIFT = 8;
    private static final int DX = (int)Math.pow(16.0, 0.0);
    private static final int DZ = (int)Math.pow(16.0, 1.0);
    private static final int DY = (int)Math.pow(16.0, 2.0);
    private static final int INVALID_INDEX = -1;
    private static final Direction[] DIRECTIONS = Direction.values();
    private final BitSet bitSet = new BitSet(4096);
    private static final int[] INDEX_OF_EDGES = Util.make(new int[1352], intArrayIn -> {
        boolean i = false;
        int j = 15;
        int k = 0;
        int l = 0;
        while (l < 16) {
            int i1 = 0;
            while (i1 < 16) {
                int j1 = 0;
                while (j1 < 16) {
                    if (l == 0 || l == 15 || i1 == 0 || i1 == 15 || j1 == 0 || j1 == 15) {
                        intArrayIn[k++] = VisGraph.getIndex(l, i1, j1);
                    }
                    ++j1;
                }
                ++i1;
            }
            ++l;
        }
    });
    private int empty = 4096;

    public void setOpaque(BlockPos pPos) {
        this.bitSet.set(VisGraph.getIndex(pPos), true);
        --this.empty;
    }

    private static int getIndex(BlockPos pPos) {
        return VisGraph.getIndex(pPos.getX() & 0xF, pPos.getY() & 0xF, pPos.getZ() & 0xF);
    }

    private static int getIndex(int pX, int pY, int pZ) {
        return pX << 0 | pY << 8 | pZ << 4;
    }

    public VisibilitySet resolve() {
        VisibilitySet visibilityset = new VisibilitySet();
        if (4096 - this.empty < 256) {
            visibilityset.setAll(true);
        } else if (this.empty == 0) {
            visibilityset.setAll(false);
        } else {
            int[] nArray = INDEX_OF_EDGES;
            int n = INDEX_OF_EDGES.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (!this.bitSet.get(i)) {
                    visibilityset.add(this.floodFill(i));
                }
                ++n2;
            }
        }
        return visibilityset;
    }

    private Set<Direction> floodFill(int pIndex) {
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        IntArrayFIFOQueue intpriorityqueue = new IntArrayFIFOQueue(384);
        intpriorityqueue.enqueue(pIndex);
        this.bitSet.set(pIndex, true);
        while (!intpriorityqueue.isEmpty()) {
            int i = intpriorityqueue.dequeueInt();
            this.addEdges(i, set);
            Direction[] directionArray = DIRECTIONS;
            int n = DIRECTIONS.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                int j = this.getNeighborIndexAtFace(i, direction);
                if (j >= 0 && !this.bitSet.get(j)) {
                    this.bitSet.set(j, true);
                    intpriorityqueue.enqueue(j);
                }
                ++n2;
            }
        }
        return set;
    }

    private void addEdges(int pIndex, Set<Direction> pFaces) {
        int i = pIndex >> 0 & 0xF;
        if (i == 0) {
            pFaces.add(Direction.WEST);
        } else if (i == 15) {
            pFaces.add(Direction.EAST);
        }
        int j = pIndex >> 8 & 0xF;
        if (j == 0) {
            pFaces.add(Direction.DOWN);
        } else if (j == 15) {
            pFaces.add(Direction.UP);
        }
        int k = pIndex >> 4 & 0xF;
        if (k == 0) {
            pFaces.add(Direction.NORTH);
        } else if (k == 15) {
            pFaces.add(Direction.SOUTH);
        }
    }

    private int getNeighborIndexAtFace(int pIndex, Direction pFace) {
        switch (pFace) {
            case DOWN: {
                if ((pIndex >> 8 & 0xF) == 0) {
                    return -1;
                }
                return pIndex - DY;
            }
            case UP: {
                if ((pIndex >> 8 & 0xF) == 15) {
                    return -1;
                }
                return pIndex + DY;
            }
            case NORTH: {
                if ((pIndex >> 4 & 0xF) == 0) {
                    return -1;
                }
                return pIndex - DZ;
            }
            case SOUTH: {
                if ((pIndex >> 4 & 0xF) == 15) {
                    return -1;
                }
                return pIndex + DZ;
            }
            case WEST: {
                if ((pIndex >> 0 & 0xF) == 0) {
                    return -1;
                }
                return pIndex - DX;
            }
            case EAST: {
                if ((pIndex >> 0 & 0xF) == 15) {
                    return -1;
                }
                return pIndex + DX;
            }
        }
        return -1;
    }
}

