/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import java.util.Set;
import net.minecraft.core.Direction;

public class VisibilitySet {
    private static final int FACINGS = Direction.values().length;
    private long bits;

    public void add(Set<Direction> pFaces) {
        for (Direction direction : pFaces) {
            for (Direction direction1 : pFaces) {
                this.set(direction, direction1, true);
            }
        }
    }

    public void set(Direction pFace, Direction pOtherFace, boolean pVisible) {
        this.setBit(pFace.ordinal() + pOtherFace.ordinal() * FACINGS, pVisible);
        this.setBit(pOtherFace.ordinal() + pFace.ordinal() * FACINGS, pVisible);
    }

    public void setAll(boolean pVisible) {
        this.bits = pVisible ? -1L : 0L;
    }

    public boolean visibilityBetween(Direction pFace, Direction pOtherFace) {
        return this.getBit(pFace.ordinal() + pOtherFace.ordinal() * FACINGS);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(' ');
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            stringbuilder.append(' ').append(direction.toString().toUpperCase().charAt(0));
            ++n2;
        }
        stringbuilder.append('\n');
        directionArray = Direction.values();
        n = directionArray.length;
        n2 = 0;
        while (n2 < n) {
            Direction direction2 = directionArray[n2];
            stringbuilder.append(direction2.toString().toUpperCase().charAt(0));
            Direction[] directionArray2 = Direction.values();
            int n3 = directionArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Direction direction1 = directionArray2[n4];
                if (direction2 == direction1) {
                    stringbuilder.append("  ");
                } else {
                    boolean flag = this.visibilityBetween(direction2, direction1);
                    stringbuilder.append(' ').append(flag ? (char)'Y' : 'n');
                }
                ++n4;
            }
            stringbuilder.append('\n');
            ++n2;
        }
        return stringbuilder.toString();
    }

    private boolean getBit(int i) {
        return (this.bits & 1L << i) != 0L;
    }

    private void setBit(int i, boolean on) {
        if (on) {
            this.setBit(i);
        } else {
            this.clearBit(i);
        }
    }

    private void setBit(int i) {
        this.bits |= 1L << i;
    }

    private void clearBit(int i) {
        this.bits &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

