/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.Path;
import org.slf4j.Logger;

public class BrainDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean SHOW_NAME_FOR_ALL = true;
    private static final boolean SHOW_PROFESSION_FOR_ALL = false;
    private static final boolean SHOW_BEHAVIORS_FOR_ALL = false;
    private static final boolean SHOW_ACTIVITIES_FOR_ALL = false;
    private static final boolean SHOW_INVENTORY_FOR_ALL = false;
    private static final boolean SHOW_GOSSIPS_FOR_ALL = false;
    private static final boolean SHOW_PATH_FOR_ALL = false;
    private static final boolean SHOW_HEALTH_FOR_ALL = false;
    private static final boolean SHOW_WANTS_GOLEM_FOR_ALL = true;
    private static final boolean SHOW_NAME_FOR_SELECTED = true;
    private static final boolean SHOW_PROFESSION_FOR_SELECTED = true;
    private static final boolean SHOW_BEHAVIORS_FOR_SELECTED = true;
    private static final boolean SHOW_ACTIVITIES_FOR_SELECTED = true;
    private static final boolean SHOW_MEMORIES_FOR_SELECTED = true;
    private static final boolean SHOW_INVENTORY_FOR_SELECTED = true;
    private static final boolean SHOW_GOSSIPS_FOR_SELECTED = true;
    private static final boolean SHOW_PATH_FOR_SELECTED = true;
    private static final boolean SHOW_HEALTH_FOR_SELECTED = true;
    private static final boolean SHOW_WANTS_GOLEM_FOR_SELECTED = true;
    private static final boolean SHOW_POI_INFO = true;
    private static final int MAX_RENDER_DIST_FOR_BRAIN_INFO = 30;
    private static final int MAX_RENDER_DIST_FOR_POI_INFO = 30;
    private static final int MAX_TARGETING_DIST = 8;
    private static final float TEXT_SCALE = 0.02f;
    private static final int WHITE = -1;
    private static final int YELLOW = -256;
    private static final int CYAN = -16711681;
    private static final int GREEN = -16711936;
    private static final int GRAY = -3355444;
    private static final int PINK = -98404;
    private static final int RED = -65536;
    private static final int ORANGE = -23296;
    private final Minecraft minecraft;
    private final Map<BlockPos, PoiInfo> pois = Maps.newHashMap();
    private final Map<UUID, BrainDump> brainDumpsPerEntity = Maps.newHashMap();
    @Nullable
    private UUID lastLookedAtUuid;

    public BrainDebugRenderer(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    @Override
    public void clear() {
        this.pois.clear();
        this.brainDumpsPerEntity.clear();
        this.lastLookedAtUuid = null;
    }

    public void addPoi(PoiInfo pPoiInfo) {
        this.pois.put(pPoiInfo.pos, pPoiInfo);
    }

    public void removePoi(BlockPos pPos) {
        this.pois.remove(pPos);
    }

    public void setFreeTicketCount(BlockPos pPos, int pFreeTicketCount) {
        PoiInfo braindebugrenderer$poiinfo = this.pois.get(pPos);
        if (braindebugrenderer$poiinfo == null) {
            LOGGER.warn("Strange, setFreeTicketCount was called for an unknown POI: {}", (Object)pPos);
        } else {
            braindebugrenderer$poiinfo.freeTicketCount = pFreeTicketCount;
        }
    }

    public void addOrUpdateBrainDump(BrainDump pBrainDump) {
        this.brainDumpsPerEntity.put(pBrainDump.uuid, pBrainDump);
    }

    public void removeBrainDump(int pId) {
        this.brainDumpsPerEntity.values().removeIf(p_173814_ -> p_173814_.id == pId);
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113217_, double pCamY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        this.clearRemovedEntities();
        this.doRender(pCamX, p_113217_, pCamY);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        if (!this.minecraft.player.isSpectator()) {
            this.updateLastLookedAtUuid();
        }
    }

    private void clearRemovedEntities() {
        this.brainDumpsPerEntity.entrySet().removeIf(p_113263_ -> {
            Entity entity = this.minecraft.level.getEntity(((BrainDump)p_113263_.getValue()).id);
            return entity == null || entity.isRemoved();
        });
    }

    private void doRender(double pX, double p_113204_, double pY) {
        BlockPos blockpos = new BlockPos(pX, p_113204_, pY);
        this.brainDumpsPerEntity.values().forEach(p_113210_ -> {
            if (this.isPlayerCloseEnoughToMob((BrainDump)p_113210_)) {
                this.renderBrainInfo((BrainDump)p_113210_, pX, p_113204_, pY);
            }
        });
        for (BlockPos blockpos1 : this.pois.keySet()) {
            if (!blockpos.closerThan(blockpos1, 30.0)) continue;
            BrainDebugRenderer.highlightPoi(blockpos1);
        }
        this.pois.values().forEach(p_113238_ -> {
            if (blockpos.closerThan(p_113238_.pos, 30.0)) {
                this.renderPoiInfo((PoiInfo)p_113238_);
            }
        });
        this.getGhostPois().forEach((p_113241_, p_113242_) -> {
            if (blockpos.closerThan((Vec3i)p_113241_, 30.0)) {
                this.renderGhostPoi((BlockPos)p_113241_, (List<String>)p_113242_);
            }
        });
    }

    private static void highlightPoi(BlockPos pPos) {
        float f = 0.05f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        DebugRenderer.renderFilledBox(pPos, 0.05f, 0.2f, 0.2f, 1.0f, 0.3f);
    }

    private void renderGhostPoi(BlockPos pPos, List<String> pNames) {
        float f = 0.05f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        DebugRenderer.renderFilledBox(pPos, 0.05f, 0.2f, 0.2f, 1.0f, 0.3f);
        BrainDebugRenderer.renderTextOverPos("" + pNames, pPos, 0, -256);
        BrainDebugRenderer.renderTextOverPos("Ghost POI", pPos, 1, -65536);
    }

    private void renderPoiInfo(PoiInfo pPoiInfo) {
        int i = 0;
        Set<String> set = this.getTicketHolderNames(pPoiInfo);
        if (set.size() < 4) {
            BrainDebugRenderer.renderTextOverPoi("Owners: " + set, pPoiInfo, i, -256);
        } else {
            BrainDebugRenderer.renderTextOverPoi(String.valueOf(set.size()) + " ticket holders", pPoiInfo, i, -256);
        }
        ++i;
        Set<String> set1 = this.getPotentialTicketHolderNames(pPoiInfo);
        if (set1.size() < 4) {
            BrainDebugRenderer.renderTextOverPoi("Candidates: " + set1, pPoiInfo, i, -23296);
        } else {
            BrainDebugRenderer.renderTextOverPoi(String.valueOf(set1.size()) + " potential owners", pPoiInfo, i, -23296);
        }
        BrainDebugRenderer.renderTextOverPoi("Free tickets: " + pPoiInfo.freeTicketCount, pPoiInfo, ++i, -256);
        BrainDebugRenderer.renderTextOverPoi(pPoiInfo.type, pPoiInfo, ++i, -1);
    }

    private void renderPath(BrainDump pBrainDump, double pX, double p_113224_, double pY) {
        if (pBrainDump.path != null) {
            PathfindingRenderer.renderPath(pBrainDump.path, 0.5f, false, false, pX, p_113224_, pY);
        }
    }

    private void renderBrainInfo(BrainDump pBrainDump, double pX, double p_113270_, double pY) {
        boolean flag = this.isMobSelected(pBrainDump);
        int i = 0;
        BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, pBrainDump.name, -1, 0.03f);
        ++i;
        if (flag) {
            BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, String.valueOf(pBrainDump.profession) + " " + pBrainDump.xp + " xp", -1, 0.02f);
            ++i;
        }
        if (flag) {
            int j = pBrainDump.health < pBrainDump.maxHealth ? -23296 : -1;
            BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, "health: " + String.format("%.1f", Float.valueOf(pBrainDump.health)) + " / " + String.format("%.1f", Float.valueOf(pBrainDump.maxHealth)), j, 0.02f);
            ++i;
        }
        if (flag && !pBrainDump.inventory.equals("")) {
            BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, pBrainDump.inventory, -98404, 0.02f);
            ++i;
        }
        if (flag) {
            for (String s : pBrainDump.behaviors) {
                BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, s, -16711681, 0.02f);
                ++i;
            }
        }
        if (flag) {
            for (String s1 : pBrainDump.activities) {
                BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, s1, -16711936, 0.02f);
                ++i;
            }
        }
        if (pBrainDump.wantsGolem) {
            BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, "Wants Golem", -23296, 0.02f);
            ++i;
        }
        if (flag) {
            for (String s2 : pBrainDump.gossips) {
                if (s2.startsWith(pBrainDump.name)) {
                    BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, s2, -1, 0.02f);
                } else {
                    BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, s2, -23296, 0.02f);
                }
                ++i;
            }
        }
        if (flag) {
            for (String s3 : Lists.reverse(pBrainDump.memories)) {
                BrainDebugRenderer.renderTextOverMob(pBrainDump.pos, i, s3, -3355444, 0.02f);
                ++i;
            }
        }
        if (flag) {
            this.renderPath(pBrainDump, pX, p_113270_, pY);
        }
    }

    private static void renderTextOverPoi(String pText, PoiInfo pPoiInfo, int pYScale, int pColor) {
        BlockPos blockpos = pPoiInfo.pos;
        BrainDebugRenderer.renderTextOverPos(pText, blockpos, pYScale, pColor);
    }

    private static void renderTextOverPos(String pText, BlockPos pPos, int pYScale, int pColor) {
        double d0 = 1.3;
        double d1 = 0.2;
        double d2 = (double)pPos.getX() + 0.5;
        double d3 = (double)pPos.getY() + 1.3 + (double)pYScale * 0.2;
        double d4 = (double)pPos.getZ() + 0.5;
        DebugRenderer.renderFloatingText(pText, d2, d3, d4, pColor, 0.02f, true, 0.0f, true);
    }

    private static void renderTextOverMob(Position pPos, int pYScale, String pText, int pColor, float pScale) {
        double d0 = 2.4;
        double d1 = 0.25;
        BlockPos blockpos = new BlockPos(pPos);
        double d2 = (double)blockpos.getX() + 0.5;
        double d3 = pPos.y() + 2.4 + (double)pYScale * 0.25;
        double d4 = (double)blockpos.getZ() + 0.5;
        float f = 0.5f;
        DebugRenderer.renderFloatingText(pText, d2, d3, d4, pColor, pScale, false, 0.5f, true);
    }

    private Set<String> getTicketHolderNames(PoiInfo pPoiInfo) {
        return this.getTicketHolders(pPoiInfo.pos).stream().map(DebugEntityNameGenerator::getEntityName).collect(Collectors.toSet());
    }

    private Set<String> getPotentialTicketHolderNames(PoiInfo pPoiInfo) {
        return this.getPotentialTicketHolders(pPoiInfo.pos).stream().map(DebugEntityNameGenerator::getEntityName).collect(Collectors.toSet());
    }

    private boolean isMobSelected(BrainDump pBrainDump) {
        return Objects.equals(this.lastLookedAtUuid, pBrainDump.uuid);
    }

    private boolean isPlayerCloseEnoughToMob(BrainDump pBrainDump) {
        LocalPlayer player = this.minecraft.player;
        BlockPos blockpos = new BlockPos(player.getX(), pBrainDump.pos.y(), player.getZ());
        BlockPos blockpos1 = new BlockPos(pBrainDump.pos);
        return blockpos.closerThan(blockpos1, 30.0);
    }

    private Collection<UUID> getTicketHolders(BlockPos pPos) {
        return this.brainDumpsPerEntity.values().stream().filter(p_113278_ -> p_113278_.hasPoi(pPos)).map(BrainDump::getUuid).collect(Collectors.toSet());
    }

    private Collection<UUID> getPotentialTicketHolders(BlockPos pPos) {
        return this.brainDumpsPerEntity.values().stream().filter(p_113235_ -> p_113235_.hasPotentialPoi(pPos)).map(BrainDump::getUuid).collect(Collectors.toSet());
    }

    private Map<BlockPos, List<String>> getGhostPois() {
        HashMap map = Maps.newHashMap();
        for (BrainDump braindebugrenderer$braindump : this.brainDumpsPerEntity.values()) {
            for (BlockPos blockpos : Iterables.concat(braindebugrenderer$braindump.pois, braindebugrenderer$braindump.potentialPois)) {
                if (this.pois.containsKey(blockpos)) continue;
                map.computeIfAbsent(blockpos, p_113292_ -> Lists.newArrayList()).add(braindebugrenderer$braindump.name);
            }
        }
        return map;
    }

    private void updateLastLookedAtUuid() {
        DebugRenderer.getTargetedEntity(this.minecraft.getCameraEntity(), 8).ifPresent(p_113212_ -> {
            this.lastLookedAtUuid = p_113212_.getUUID();
        });
    }

    public static class BrainDump {
        public final UUID uuid;
        public final int id;
        public final String name;
        public final String profession;
        public final int xp;
        public final float health;
        public final float maxHealth;
        public final Position pos;
        public final String inventory;
        public final Path path;
        public final boolean wantsGolem;
        public final List<String> activities = Lists.newArrayList();
        public final List<String> behaviors = Lists.newArrayList();
        public final List<String> memories = Lists.newArrayList();
        public final List<String> gossips = Lists.newArrayList();
        public final Set<BlockPos> pois = Sets.newHashSet();
        public final Set<BlockPos> potentialPois = Sets.newHashSet();

        public BrainDump(UUID pUuid, int pId, String pName, String pProfession, int pXp, float pHealth, float pMaxHealth, Position pPos, String pInventory, @Nullable Path pPath, boolean pWantsGolem) {
            this.uuid = pUuid;
            this.id = pId;
            this.name = pName;
            this.profession = pProfession;
            this.xp = pXp;
            this.health = pHealth;
            this.maxHealth = pMaxHealth;
            this.pos = pPos;
            this.inventory = pInventory;
            this.path = pPath;
            this.wantsGolem = pWantsGolem;
        }

        boolean hasPoi(BlockPos pPos) {
            return this.pois.stream().anyMatch(pPos::equals);
        }

        boolean hasPotentialPoi(BlockPos pPos) {
            return this.potentialPois.contains(pPos);
        }

        public UUID getUuid() {
            return this.uuid;
        }
    }

    public static class PoiInfo {
        public final BlockPos pos;
        public String type;
        public int freeTicketCount;

        public PoiInfo(BlockPos pPos, String pType, int pFreeTicketCount) {
            this.pos = pPos;
            this.type = pType;
            this.freeTicketCount = pFreeTicketCount;
        }
    }
}

