/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.optifine.Config;
import net.optifine.shaders.Shaders;

public class ChunkBorderRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Minecraft minecraft;
    private static final int CELL_BORDER = FastColor.ARGB32.color(255, 0, 155, 155);
    private static final int YELLOW = FastColor.ARGB32.color(255, 255, 255, 0);

    public ChunkBorderRenderer(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113361_, double pCamY) {
        if (!Shaders.isShadowPass) {
            if (Config.isShaders()) {
                Shaders.beginLeash();
            }
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Entity entity = this.minecraft.gameRenderer.getMainCamera().getEntity();
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tesselator.getBuilder();
            double d0 = (double)this.minecraft.level.getMinBuildHeight() - p_113361_;
            double d1 = (double)this.minecraft.level.getMaxBuildHeight() - p_113361_;
            RenderSystem.disableTexture();
            RenderSystem.disableBlend();
            ChunkPos chunkpos = entity.chunkPosition();
            double d2 = (double)chunkpos.getMinBlockX() - pCamX;
            double d3 = (double)chunkpos.getMinBlockZ() - pCamY;
            RenderSystem.lineWidth(1.0f);
            bufferbuilder.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            int i = -16;
            while (i <= 32) {
                int j = -16;
                while (j <= 32) {
                    bufferbuilder.vertex(d2 + (double)i, d0, d3 + (double)j).color(1.0f, 0.0f, 0.0f, 0.0f).endVertex();
                    bufferbuilder.vertex(d2 + (double)i, d0, d3 + (double)j).color(1.0f, 0.0f, 0.0f, 0.5f).endVertex();
                    bufferbuilder.vertex(d2 + (double)i, d1, d3 + (double)j).color(1.0f, 0.0f, 0.0f, 0.5f).endVertex();
                    bufferbuilder.vertex(d2 + (double)i, d1, d3 + (double)j).color(1.0f, 0.0f, 0.0f, 0.0f).endVertex();
                    j += 16;
                }
                i += 16;
            }
            int l = 2;
            while (l < 16) {
                int i2 = l % 4 == 0 ? CELL_BORDER : YELLOW;
                bufferbuilder.vertex(d2 + (double)l, d0, d3).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                bufferbuilder.vertex(d2 + (double)l, d0, d3).color(i2).endVertex();
                bufferbuilder.vertex(d2 + (double)l, d1, d3).color(i2).endVertex();
                bufferbuilder.vertex(d2 + (double)l, d1, d3).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                bufferbuilder.vertex(d2 + (double)l, d0, d3 + 16.0).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                bufferbuilder.vertex(d2 + (double)l, d0, d3 + 16.0).color(i2).endVertex();
                bufferbuilder.vertex(d2 + (double)l, d1, d3 + 16.0).color(i2).endVertex();
                bufferbuilder.vertex(d2 + (double)l, d1, d3 + 16.0).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                l += 2;
            }
            int i1 = 2;
            while (i1 < 16) {
                int j2 = i1 % 4 == 0 ? CELL_BORDER : YELLOW;
                bufferbuilder.vertex(d2, d0, d3 + (double)i1).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                bufferbuilder.vertex(d2, d0, d3 + (double)i1).color(j2).endVertex();
                bufferbuilder.vertex(d2, d1, d3 + (double)i1).color(j2).endVertex();
                bufferbuilder.vertex(d2, d1, d3 + (double)i1).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                bufferbuilder.vertex(d2 + 16.0, d0, d3 + (double)i1).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                bufferbuilder.vertex(d2 + 16.0, d0, d3 + (double)i1).color(j2).endVertex();
                bufferbuilder.vertex(d2 + 16.0, d1, d3 + (double)i1).color(j2).endVertex();
                bufferbuilder.vertex(d2 + 16.0, d1, d3 + (double)i1).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                i1 += 2;
            }
            int j1 = this.minecraft.level.getMinBuildHeight();
            while (j1 <= this.minecraft.level.getMaxBuildHeight()) {
                double d4 = (double)j1 - p_113361_;
                int k = j1 % 8 == 0 ? CELL_BORDER : YELLOW;
                bufferbuilder.vertex(d2, d4, d3).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                bufferbuilder.vertex(d2, d4, d3).color(k).endVertex();
                bufferbuilder.vertex(d2, d4, d3 + 16.0).color(k).endVertex();
                bufferbuilder.vertex(d2 + 16.0, d4, d3 + 16.0).color(k).endVertex();
                bufferbuilder.vertex(d2 + 16.0, d4, d3).color(k).endVertex();
                bufferbuilder.vertex(d2, d4, d3).color(k).endVertex();
                bufferbuilder.vertex(d2, d4, d3).color(1.0f, 1.0f, 0.0f, 0.0f).endVertex();
                j1 += 2;
            }
            tesselator.end();
            RenderSystem.lineWidth(2.0f);
            bufferbuilder.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            int k1 = 0;
            while (k1 <= 16) {
                int k2 = 0;
                while (k2 <= 16) {
                    bufferbuilder.vertex(d2 + (double)k1, d0, d3 + (double)k2).color(0.25f, 0.25f, 1.0f, 0.0f).endVertex();
                    bufferbuilder.vertex(d2 + (double)k1, d0, d3 + (double)k2).color(0.25f, 0.25f, 1.0f, 1.0f).endVertex();
                    bufferbuilder.vertex(d2 + (double)k1, d1, d3 + (double)k2).color(0.25f, 0.25f, 1.0f, 1.0f).endVertex();
                    bufferbuilder.vertex(d2 + (double)k1, d1, d3 + (double)k2).color(0.25f, 0.25f, 1.0f, 0.0f).endVertex();
                    k2 += 16;
                }
                k1 += 16;
            }
            int l1 = this.minecraft.level.getMinBuildHeight();
            while (l1 <= this.minecraft.level.getMaxBuildHeight()) {
                double d5 = (double)l1 - p_113361_;
                bufferbuilder.vertex(d2, d5, d3).color(0.25f, 0.25f, 1.0f, 0.0f).endVertex();
                bufferbuilder.vertex(d2, d5, d3).color(0.25f, 0.25f, 1.0f, 1.0f).endVertex();
                bufferbuilder.vertex(d2, d5, d3 + 16.0).color(0.25f, 0.25f, 1.0f, 1.0f).endVertex();
                bufferbuilder.vertex(d2 + 16.0, d5, d3 + 16.0).color(0.25f, 0.25f, 1.0f, 1.0f).endVertex();
                bufferbuilder.vertex(d2 + 16.0, d5, d3).color(0.25f, 0.25f, 1.0f, 1.0f).endVertex();
                bufferbuilder.vertex(d2, d5, d3).color(0.25f, 0.25f, 1.0f, 1.0f).endVertex();
                bufferbuilder.vertex(d2, d5, d3).color(0.25f, 0.25f, 1.0f, 0.0f).endVertex();
                l1 += 16;
            }
            tesselator.end();
            RenderSystem.lineWidth(1.0f);
            RenderSystem.enableBlend();
            RenderSystem.enableTexture();
            if (Config.isShaders()) {
                Shaders.endLeash();
            }
        }
    }
}

