/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    final Minecraft minecraft;
    private double lastUpdateTime = Double.MIN_VALUE;
    private final int radius = 12;
    @Nullable
    private ChunkData data;

    public ChunkDebugRenderer(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113373_, double pCamY) {
        double d0 = Util.getNanos();
        if (d0 - this.lastUpdateTime > 3.0E9) {
            this.lastUpdateTime = d0;
            IntegratedServer integratedserver = this.minecraft.getSingleplayerServer();
            this.data = integratedserver != null ? new ChunkData(integratedserver, pCamX, pCamY) : null;
        }
        if (this.data != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth(2.0f);
            RenderSystem.disableTexture();
            RenderSystem.depthMask(false);
            Map map = this.data.serverData.getNow(null);
            double d1 = this.minecraft.gameRenderer.getMainCamera().getPosition().y * 0.85;
            for (Map.Entry<ChunkPos, String> entry : this.data.clientData.entrySet()) {
                ChunkPos chunkpos = entry.getKey();
                String s = entry.getValue();
                if (map != null) {
                    s = String.valueOf(s) + (String)map.get(chunkpos);
                }
                String[] astring = s.split("\n");
                int i = 0;
                String[] stringArray = astring;
                int n = astring.length;
                int n2 = 0;
                while (n2 < n) {
                    String s1 = stringArray[n2];
                    DebugRenderer.renderFloatingText(s1, SectionPos.sectionToBlockCoord(chunkpos.x, 8), d1 + (double)i, SectionPos.sectionToBlockCoord(chunkpos.z, 8), -1, 0.15f);
                    i -= 2;
                    ++n2;
                }
            }
            RenderSystem.depthMask(true);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    final class ChunkData {
        final Map<ChunkPos, String> clientData;
        final CompletableFuture<Map<ChunkPos, String>> serverData;

        ChunkData(IntegratedServer p_113382_, double p_113383_, double p_113384_) {
            ClientLevel clientlevel = ChunkDebugRenderer.this.minecraft.level;
            ResourceKey<Level> resourcekey = clientlevel.dimension();
            int i = SectionPos.posToSectionCoord(p_113383_);
            int j = SectionPos.posToSectionCoord(p_113384_);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ClientChunkCache clientchunkcache = clientlevel.getChunkSource();
            int k = i - 12;
            while (k <= i + 12) {
                int l = j - 12;
                while (l <= j + 12) {
                    ChunkPos chunkpos = new ChunkPos(k, l);
                    String s = "";
                    LevelChunk levelchunk = clientchunkcache.getChunk(k, l, false);
                    s = String.valueOf(s) + "Client: ";
                    if (levelchunk == null) {
                        s = String.valueOf(s) + "0n/a\n";
                    } else {
                        s = String.valueOf(s) + (levelchunk.isEmpty() ? " E" : "");
                        s = String.valueOf(s) + "\n";
                    }
                    builder.put((Object)chunkpos, (Object)s);
                    ++l;
                }
                ++k;
            }
            this.clientData = builder.build();
            this.serverData = p_113382_.submit(() -> {
                ServerLevel serverlevel = p_113382_.getLevel(resourcekey);
                if (serverlevel == null) {
                    return ImmutableMap.of();
                }
                ImmutableMap.Builder builder1 = ImmutableMap.builder();
                ServerChunkCache serverchunkcache = serverlevel.getChunkSource();
                int i1 = i - 12;
                while (i1 <= i + 12) {
                    int j1 = j - 12;
                    while (j1 <= j + 12) {
                        ChunkPos chunkpos1 = new ChunkPos(i1, j1);
                        builder1.put((Object)chunkpos1, (Object)("Server: " + serverchunkcache.getChunkDebugData(chunkpos1)));
                        ++j1;
                    }
                    ++i1;
                }
                return builder1.build();
            });
        }
    }
}

