/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class GameEventListenerRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Minecraft minecraft;
    private static final int LISTENER_RENDER_DIST = 32;
    private static final float BOX_HEIGHT = 1.0f;
    private final List<TrackedGameEvent> trackedGameEvents = Lists.newArrayList();
    private final List<TrackedListener> trackedListeners = Lists.newArrayList();

    public GameEventListenerRenderer(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_173849_, double pCamY) {
        ClientLevel level = this.minecraft.level;
        if (level == null) {
            this.trackedGameEvents.clear();
            this.trackedListeners.clear();
        } else {
            BlockPos blockpos = new BlockPos(pCamX, 0.0, pCamY);
            this.trackedGameEvents.removeIf(TrackedGameEvent::isExpired);
            this.trackedListeners.removeIf(p_173826_ -> p_173826_.isExpired(level, blockpos));
            RenderSystem.disableTexture();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            VertexConsumer vertexconsumer = pBufferSource.getBuffer(RenderType.lines());
            for (TrackedListener gameeventlistenerrenderer$trackedlistener : this.trackedListeners) {
                gameeventlistenerrenderer$trackedlistener.getPosition(level).ifPresent(p_173858_ -> {
                    int i = p_173858_.getX() - gameeventlistenerrenderer$trackedlistener.getListenerRadius();
                    int j = p_173858_.getY() - gameeventlistenerrenderer$trackedlistener.getListenerRadius();
                    int k = p_173858_.getZ() - gameeventlistenerrenderer$trackedlistener.getListenerRadius();
                    int l = p_173858_.getX() + gameeventlistenerrenderer$trackedlistener.getListenerRadius();
                    int i1 = p_173858_.getY() + gameeventlistenerrenderer$trackedlistener.getListenerRadius();
                    int j1 = p_173858_.getZ() + gameeventlistenerrenderer$trackedlistener.getListenerRadius();
                    Vector3f vector3f = new Vector3f(1.0f, 1.0f, 0.0f);
                    LevelRenderer.renderVoxelShape(pPoseStack, vertexconsumer, Shapes.create(new AABB(i, j, k, l, i1, j1)), -pCamX, -p_173849_, -pCamY, vector3f.x(), vector3f.y(), vector3f.z(), 0.35f);
                });
            }
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tesselator.getBuilder();
            bufferbuilder.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (TrackedListener gameeventlistenerrenderer$trackedlistener1 : this.trackedListeners) {
                gameeventlistenerrenderer$trackedlistener1.getPosition(level).ifPresent(p_173844_ -> {
                    Vector3f vector3f = new Vector3f(1.0f, 1.0f, 0.0f);
                    LevelRenderer.addChainedFilledBoxVertices(bufferbuilder, (double)((float)p_173844_.getX() - 0.25f) - pCamX, (double)p_173844_.getY() - p_173849_, (double)((float)p_173844_.getZ() - 0.25f) - pCamY, (double)((float)p_173844_.getX() + 0.25f) - pCamX, (double)p_173844_.getY() - p_173849_ + 1.0, (double)((float)p_173844_.getZ() + 0.25f) - pCamY, vector3f.x(), vector3f.y(), vector3f.z(), 0.35f);
                });
            }
            tesselator.end();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth(2.0f);
            RenderSystem.depthMask(false);
            for (TrackedListener gameeventlistenerrenderer$trackedlistener2 : this.trackedListeners) {
                gameeventlistenerrenderer$trackedlistener2.getPosition(level).ifPresent(p_173860_ -> {
                    DebugRenderer.renderFloatingText("Listener Origin", p_173860_.getX(), (float)p_173860_.getY() + 1.8f, p_173860_.getZ(), -1, 0.025f);
                    DebugRenderer.renderFloatingText(new BlockPos((Vec3i)p_173860_).toString(), p_173860_.getX(), (float)p_173860_.getY() + 1.5f, p_173860_.getZ(), -6959665, 0.025f);
                });
            }
            for (TrackedGameEvent gameeventlistenerrenderer$trackedgameevent : this.trackedGameEvents) {
                Vec3 vec3 = gameeventlistenerrenderer$trackedgameevent.position;
                double d0 = 0.2f;
                double d1 = vec3.x - (double)0.2f;
                double d2 = vec3.y - (double)0.2f;
                double d3 = vec3.z - (double)0.2f;
                double d4 = vec3.x + (double)0.2f;
                double d5 = vec3.y + (double)0.2f + 0.5;
                double d6 = vec3.z + (double)0.2f;
                GameEventListenerRenderer.renderTransparentFilledBox(new AABB(d1, d2, d3, d4, d5, d6), 1.0f, 1.0f, 1.0f, 0.2f);
                DebugRenderer.renderFloatingText(gameeventlistenerrenderer$trackedgameevent.gameEvent.getName(), vec3.x, vec3.y + (double)0.85f, vec3.z, -7564911, 0.0075f);
            }
            RenderSystem.depthMask(true);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    private static void renderTransparentFilledBox(AABB pBox, float pRed, float pGreen, float pBlue, float pAlpha) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        if (camera.isInitialized()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Vec3 vec3 = camera.getPosition().reverse();
            DebugRenderer.renderFilledBox(pBox.move(vec3), pRed, pGreen, pBlue, pAlpha);
        }
    }

    public void trackGameEvent(GameEvent pEvent, BlockPos pPos) {
        this.trackedGameEvents.add(new TrackedGameEvent(Util.getMillis(), pEvent, Vec3.atBottomCenterOf(pPos)));
    }

    public void trackListener(PositionSource pListenerSource, int pListenerRange) {
        this.trackedListeners.add(new TrackedListener(pListenerSource, pListenerRange));
    }

    static class TrackedGameEvent {
        public final long timeStamp;
        public final GameEvent gameEvent;
        public final Vec3 position;

        public TrackedGameEvent(long pTimeStamp, GameEvent p_173866_, Vec3 pGameEvent) {
            this.timeStamp = pTimeStamp;
            this.gameEvent = p_173866_;
            this.position = pGameEvent;
        }

        public boolean isExpired() {
            return Util.getMillis() - this.timeStamp > 3000L;
        }
    }

    static class TrackedListener
    implements GameEventListener {
        public final PositionSource listenerSource;
        public final int listenerRange;

        public TrackedListener(PositionSource pListenerSource, int pListenerRange) {
            this.listenerSource = pListenerSource;
            this.listenerRange = pListenerRange;
        }

        public boolean isExpired(Level pLevel, BlockPos pPos) {
            Optional<BlockPos> optional = this.listenerSource.getPosition(pLevel);
            return !optional.isPresent() || optional.get().distSqr(pPos) <= 1024.0;
        }

        public Optional<BlockPos> getPosition(Level pLevel) {
            return this.listenerSource.getPosition(pLevel);
        }

        @Override
        public PositionSource getListenerSource() {
            return this.listenerSource;
        }

        @Override
        public int getListenerRadius() {
            return this.listenerRange;
        }

        @Override
        public boolean handleGameEvent(Level pLevel, GameEvent pEvent, @Nullable Entity pEntity, BlockPos pPos) {
            return false;
        }
    }
}

