/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;

public class GameTestDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private static final float PADDING = 0.02f;
    private final Map<BlockPos, Marker> markers = Maps.newHashMap();

    public void addMarker(BlockPos pPos, int pColor, String pText, int pRemoveAfter) {
        this.markers.put(pPos, new Marker(pColor, pText, Util.getMillis() + (long)pRemoveAfter));
    }

    @Override
    public void clear() {
        this.markers.clear();
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113522_, double pCamY) {
        long i = Util.getMillis();
        this.markers.entrySet().removeIf(p_113517_ -> i > ((Marker)p_113517_.getValue()).removeAtTime);
        this.markers.forEach(this::renderMarker);
    }

    private void renderMarker(BlockPos p_113530_, Marker p_113531_) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor(0.0f, 1.0f, 0.0f, 0.75f);
        RenderSystem.disableTexture();
        DebugRenderer.renderFilledBox(p_113530_, 0.02f, p_113531_.getR(), p_113531_.getG(), p_113531_.getB(), p_113531_.getA());
        if (!p_113531_.text.isEmpty()) {
            double d0 = (double)p_113530_.getX() + 0.5;
            double d1 = (double)p_113530_.getY() + 1.2;
            double d2 = (double)p_113530_.getZ() + 0.5;
            DebugRenderer.renderFloatingText(p_113531_.text, d0, d1, d2, -1, 0.01f, true, 0.0f, true);
        }
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    static class Marker {
        public int color;
        public String text;
        public long removeAtTime;

        public Marker(int pColor, String pText, long pRemoveAtTime) {
            this.color = pColor;
            this.text = pText;
            this.removeAtTime = pRemoveAtTime;
        }

        public float getR() {
            return (float)(this.color >> 16 & 0xFF) / 255.0f;
        }

        public float getG() {
            return (float)(this.color >> 8 & 0xFF) / 255.0f;
        }

        public float getB() {
            return (float)(this.color & 0xFF) / 255.0f;
        }

        public float getA() {
            return (float)(this.color >> 24 & 0xFF) / 255.0f;
        }
    }
}

