/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;

public class GoalSelectorDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private static final int MAX_RENDER_DIST = 160;
    private final Minecraft minecraft;
    private final Map<Integer, List<DebugGoal>> goalSelectors = Maps.newHashMap();

    @Override
    public void clear() {
        this.goalSelectors.clear();
    }

    public void addGoalSelector(int pMobId, List<DebugGoal> pGoals) {
        this.goalSelectors.put(pMobId, pGoals);
    }

    public void removeGoalSelector(int pMobId) {
        this.goalSelectors.remove(pMobId);
    }

    public GoalSelectorDebugRenderer(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113555_, double pCamY) {
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        BlockPos blockpos = new BlockPos(camera.getPosition().x, 0.0, camera.getPosition().z);
        this.goalSelectors.forEach((p_113559_, p_113560_) -> {
            int i = 0;
            while (i < p_113560_.size()) {
                DebugGoal goalselectordebugrenderer$debuggoal = (DebugGoal)p_113560_.get(i);
                if (blockpos.closerThan(goalselectordebugrenderer$debuggoal.pos, 160.0)) {
                    double d0 = (double)goalselectordebugrenderer$debuggoal.pos.getX() + 0.5;
                    double d1 = (double)goalselectordebugrenderer$debuggoal.pos.getY() + 2.0 + (double)i * 0.25;
                    double d2 = (double)goalselectordebugrenderer$debuggoal.pos.getZ() + 0.5;
                    int j = goalselectordebugrenderer$debuggoal.isRunning ? -16711936 : -3355444;
                    DebugRenderer.renderFloatingText(goalselectordebugrenderer$debuggoal.name, d0, d1, d2, j);
                }
                ++i;
            }
        });
        RenderSystem.enableDepthTest();
        RenderSystem.enableTexture();
    }

    public static class DebugGoal {
        public final BlockPos pos;
        public final int priority;
        public final String name;
        public final boolean isRunning;

        public DebugGoal(BlockPos pPos, int pPriority, String pName, boolean pIsRunning) {
            this.pos = pPos;
            this.priority = pPriority;
            this.name = pName;
            this.isRunning = pIsRunning;
        }
    }
}

