/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class NeighborsUpdateRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Minecraft minecraft;
    private final Map<Long, Map<BlockPos, Integer>> lastUpdate = Maps.newTreeMap((Comparator)Ordering.natural().reverse());

    NeighborsUpdateRenderer(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    public void addUpdate(long pGameTime, BlockPos p_113598_) {
        Map map = this.lastUpdate.computeIfAbsent(pGameTime, p_113606_ -> Maps.newHashMap());
        int i = map.getOrDefault(p_113598_, 0);
        map.put(p_113598_, i + 1);
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113603_, double pCamY) {
        long i = this.minecraft.level.getGameTime();
        int j = 200;
        double d0 = 0.0025;
        HashSet set = Sets.newHashSet();
        HashMap map = Maps.newHashMap();
        VertexConsumer vertexconsumer = pBufferSource.getBuffer(RenderType.lines());
        Iterator<Map.Entry<Long, Map<BlockPos, Integer>>> iterator = this.lastUpdate.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<BlockPos, Integer>> entry = iterator.next();
            Long olong = entry.getKey();
            Map<BlockPos, Integer> map1 = entry.getValue();
            long k = i - olong;
            if (k > 200L) {
                iterator.remove();
                continue;
            }
            for (Map.Entry<BlockPos, Integer> entry1 : map1.entrySet()) {
                BlockPos blockpos = entry1.getKey();
                Integer integer = entry1.getValue();
                if (!set.add(blockpos)) continue;
                AABB aabb = new AABB(BlockPos.ZERO).inflate(0.002).deflate(0.0025 * (double)k).move(blockpos.getX(), blockpos.getY(), blockpos.getZ()).move(-pCamX, -p_113603_, -pCamY);
                LevelRenderer.renderLineBox(pPoseStack, vertexconsumer, aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ, 1.0f, 1.0f, 1.0f, 1.0f);
                map.put(blockpos, integer);
            }
        }
        for (Map.Entry entry2 : map.entrySet()) {
            BlockPos blockpos1 = (BlockPos)entry2.getKey();
            Integer integer1 = (Integer)entry2.getValue();
            DebugRenderer.renderFloatingText(String.valueOf(integer1), blockpos1.getX(), blockpos1.getY(), blockpos1.getZ(), -1);
        }
    }
}

