/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class PathfindingRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Map<Integer, Path> pathMap = Maps.newHashMap();
    private final Map<Integer, Float> pathMaxDist = Maps.newHashMap();
    private final Map<Integer, Long> creationMap = Maps.newHashMap();
    private static final long TIMEOUT = 5000L;
    private static final float MAX_RENDER_DIST = 80.0f;
    private static final boolean SHOW_OPEN_CLOSED = true;
    private static final boolean SHOW_OPEN_CLOSED_COST_MALUS = false;
    private static final boolean SHOW_OPEN_CLOSED_NODE_TYPE_WITH_TEXT = false;
    private static final boolean SHOW_OPEN_CLOSED_NODE_TYPE_WITH_BOX = true;
    private static final boolean SHOW_GROUND_LABELS = true;
    private static final float TEXT_SCALE = 0.02f;

    public void addPath(int pEntityId, Path pPath, float pMaxDistanceToWaypoint) {
        this.pathMap.put(pEntityId, pPath);
        this.creationMap.put(pEntityId, Util.getMillis());
        this.pathMaxDist.put(pEntityId, Float.valueOf(pMaxDistanceToWaypoint));
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113632_, double pCamY) {
        if (!this.pathMap.isEmpty()) {
            long i = Util.getMillis();
            for (Integer integer : this.pathMap.keySet()) {
                Path path = this.pathMap.get(integer);
                float f = this.pathMaxDist.get(integer).floatValue();
                PathfindingRenderer.renderPath(path, f, true, true, pCamX, p_113632_, pCamY);
            }
            Integer[] integerArray = this.creationMap.keySet().toArray(new Integer[0]);
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer integer1 = integerArray[n2];
                if (i - this.creationMap.get(integer1) > 5000L) {
                    this.pathMap.remove(integer1);
                    this.creationMap.remove(integer1);
                }
                ++n2;
            }
        }
    }

    public static void renderPath(Path pPath, float pMaxDistanceToWaypoint, boolean pRenderOpenAndClosedSet, boolean pRenderText, double pX, double p_113626_, double pY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor(0.0f, 1.0f, 0.0f, 0.75f);
        RenderSystem.disableTexture();
        RenderSystem.lineWidth(6.0f);
        PathfindingRenderer.doRenderPath(pPath, pMaxDistanceToWaypoint, pRenderOpenAndClosedSet, pRenderText, pX, p_113626_, pY);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    private static void doRenderPath(Path pPath, float pMaxDistanceToWaypoint, boolean pRenderOpenAndClosedSet, boolean pRenderText, double pX, double p_113645_, double pY) {
        PathfindingRenderer.renderPathLine(pPath, pX, p_113645_, pY);
        BlockPos blockpos = pPath.getTarget();
        if (PathfindingRenderer.distanceToCamera(blockpos, pX, p_113645_, pY) <= 80.0f) {
            DebugRenderer.renderFilledBox(new AABB((float)blockpos.getX() + 0.25f, (float)blockpos.getY() + 0.25f, (double)blockpos.getZ() + 0.25, (float)blockpos.getX() + 0.75f, (float)blockpos.getY() + 0.75f, (float)blockpos.getZ() + 0.75f).move(-pX, -p_113645_, -pY), 0.0f, 1.0f, 0.0f, 0.5f);
            int i = 0;
            while (i < pPath.getNodeCount()) {
                Node node = pPath.getNode(i);
                if (PathfindingRenderer.distanceToCamera(node.asBlockPos(), pX, p_113645_, pY) <= 80.0f) {
                    float f = i == pPath.getNextNodeIndex() ? 1.0f : 0.0f;
                    float f1 = i == pPath.getNextNodeIndex() ? 0.0f : 1.0f;
                    DebugRenderer.renderFilledBox(new AABB((float)node.x + 0.5f - pMaxDistanceToWaypoint, (float)node.y + 0.01f * (float)i, (float)node.z + 0.5f - pMaxDistanceToWaypoint, (float)node.x + 0.5f + pMaxDistanceToWaypoint, (float)node.y + 0.25f + 0.01f * (float)i, (float)node.z + 0.5f + pMaxDistanceToWaypoint).move(-pX, -p_113645_, -pY), f, 0.0f, f1, 0.5f);
                }
                ++i;
            }
        }
        if (pRenderOpenAndClosedSet) {
            Node[] nodeArray = pPath.getClosedSet();
            int n = nodeArray.length;
            int node = 0;
            while (node < n) {
                Node node2 = nodeArray[node];
                if (PathfindingRenderer.distanceToCamera(node2.asBlockPos(), pX, p_113645_, pY) <= 80.0f) {
                    DebugRenderer.renderFilledBox(new AABB((float)node2.x + 0.5f - pMaxDistanceToWaypoint / 2.0f, (float)node2.y + 0.01f, (float)node2.z + 0.5f - pMaxDistanceToWaypoint / 2.0f, (float)node2.x + 0.5f + pMaxDistanceToWaypoint / 2.0f, (double)node2.y + 0.1, (float)node2.z + 0.5f + pMaxDistanceToWaypoint / 2.0f).move(-pX, -p_113645_, -pY), 1.0f, 0.8f, 0.8f, 0.5f);
                }
                ++node;
            }
            nodeArray = pPath.getOpenSet();
            n = nodeArray.length;
            node = 0;
            while (node < n) {
                Node node3 = nodeArray[node];
                if (PathfindingRenderer.distanceToCamera(node3.asBlockPos(), pX, p_113645_, pY) <= 80.0f) {
                    DebugRenderer.renderFilledBox(new AABB((float)node3.x + 0.5f - pMaxDistanceToWaypoint / 2.0f, (float)node3.y + 0.01f, (float)node3.z + 0.5f - pMaxDistanceToWaypoint / 2.0f, (float)node3.x + 0.5f + pMaxDistanceToWaypoint / 2.0f, (double)node3.y + 0.1, (float)node3.z + 0.5f + pMaxDistanceToWaypoint / 2.0f).move(-pX, -p_113645_, -pY), 0.8f, 1.0f, 1.0f, 0.5f);
                }
                ++node;
            }
        }
        if (pRenderText) {
            int j = 0;
            while (j < pPath.getNodeCount()) {
                Node node1 = pPath.getNode(j);
                if (PathfindingRenderer.distanceToCamera(node1.asBlockPos(), pX, p_113645_, pY) <= 80.0f) {
                    DebugRenderer.renderFloatingText(String.format("%s", new Object[]{node1.type}), (double)node1.x + 0.5, (double)node1.y + 0.75, (double)node1.z + 0.5, -1, 0.02f, true, 0.0f, true);
                    DebugRenderer.renderFloatingText(String.format(Locale.ROOT, "%.2f", Float.valueOf(node1.costMalus)), (double)node1.x + 0.5, (double)node1.y + 0.25, (double)node1.z + 0.5, -1, 0.02f, true, 0.0f, true);
                }
                ++j;
            }
        }
    }

    public static void renderPathLine(Path pPath, double pX, double p_113618_, double pY) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder.begin(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        int i = 0;
        while (i < pPath.getNodeCount()) {
            Node node = pPath.getNode(i);
            if (!(PathfindingRenderer.distanceToCamera(node.asBlockPos(), pX, p_113618_, pY) > 80.0f)) {
                float f = (float)i / (float)pPath.getNodeCount() * 0.33f;
                int j = i == 0 ? 0 : Mth.hsvToRgb(f, 0.9f, 0.9f);
                int k = j >> 16 & 0xFF;
                int l = j >> 8 & 0xFF;
                int i1 = j & 0xFF;
                bufferbuilder.vertex((double)node.x - pX + 0.5, (double)node.y - p_113618_ + 0.5, (double)node.z - pY + 0.5).color(k, l, i1, 255).endVertex();
            }
            ++i;
        }
        tesselator.end();
    }

    private static float distanceToCamera(BlockPos pPos, double pX, double p_113637_, double pY) {
        return (float)(Math.abs((double)pPos.getX() - pX) + Math.abs((double)pPos.getY() - p_113637_) + Math.abs((double)pPos.getZ() - pY));
    }
}

