/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;

public class RaidDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private static final int MAX_RENDER_DIST = 160;
    private static final float TEXT_SCALE = 0.04f;
    private final Minecraft minecraft;
    private Collection<BlockPos> raidCenters = Lists.newArrayList();

    public RaidDebugRenderer(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    public void setRaidCenters(Collection<BlockPos> pRaidCenters) {
        this.raidCenters = pRaidCenters;
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113655_, double pCamY) {
        BlockPos blockpos = this.getCamera().getBlockPosition();
        for (BlockPos blockpos1 : this.raidCenters) {
            if (!blockpos.closerThan(blockpos1, 160.0)) continue;
            RaidDebugRenderer.highlightRaidCenter(blockpos1);
        }
    }

    private static void highlightRaidCenter(BlockPos pPos) {
        DebugRenderer.renderFilledBox(pPos.offset(-0.5, -0.5, -0.5), pPos.offset(1.5, 1.5, 1.5), 1.0f, 0.0f, 0.0f, 0.15f);
        int i = -65536;
        RaidDebugRenderer.renderTextOverBlock("Raid center", pPos, -65536);
    }

    private static void renderTextOverBlock(String pText, BlockPos pPos, int pColor) {
        double d0 = (double)pPos.getX() + 0.5;
        double d1 = (double)pPos.getY() + 1.3;
        double d2 = (double)pPos.getZ() + 0.5;
        DebugRenderer.renderFloatingText(pText, d0, d1, d2, pColor, 0.04f, true, 0.0f, true);
    }

    private Camera getCamera() {
        return this.minecraft.gameRenderer.getMainCamera();
    }
}

