/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class StructureRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Minecraft minecraft;
    private final Map<DimensionType, Map<String, BoundingBox>> postMainBoxes = Maps.newIdentityHashMap();
    private final Map<DimensionType, Map<String, BoundingBox>> postPiecesBoxes = Maps.newIdentityHashMap();
    private final Map<DimensionType, Map<String, Boolean>> startPiecesMap = Maps.newIdentityHashMap();
    private static final int MAX_RENDER_DIST = 500;

    public StructureRenderer(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113691_, double pCamY) {
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        ClientLevel levelaccessor = this.minecraft.level;
        DimensionType dimensiontype = levelaccessor.dimensionType();
        BlockPos blockpos = new BlockPos(camera.getPosition().x, 0.0, camera.getPosition().z);
        VertexConsumer vertexconsumer = pBufferSource.getBuffer(RenderType.lines());
        if (this.postMainBoxes.containsKey(dimensiontype)) {
            for (BoundingBox boundingBox : this.postMainBoxes.get(dimensiontype).values()) {
                if (!blockpos.closerThan(boundingBox.getCenter(), 500.0)) continue;
                LevelRenderer.renderLineBox(pPoseStack, vertexconsumer, (double)boundingBox.minX() - pCamX, (double)boundingBox.minY() - p_113691_, (double)boundingBox.minZ() - pCamY, (double)(boundingBox.maxX() + 1) - pCamX, (double)(boundingBox.maxY() + 1) - p_113691_, (double)(boundingBox.maxZ() + 1) - pCamY, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (this.postPiecesBoxes.containsKey(dimensiontype)) {
            for (Map.Entry entry : this.postPiecesBoxes.get(dimensiontype).entrySet()) {
                String s = (String)entry.getKey();
                BoundingBox boundingbox1 = (BoundingBox)entry.getValue();
                Boolean obool = this.startPiecesMap.get(dimensiontype).get(s);
                if (!blockpos.closerThan(boundingbox1.getCenter(), 500.0)) continue;
                if (obool.booleanValue()) {
                    LevelRenderer.renderLineBox(pPoseStack, vertexconsumer, (double)boundingbox1.minX() - pCamX, (double)boundingbox1.minY() - p_113691_, (double)boundingbox1.minZ() - pCamY, (double)(boundingbox1.maxX() + 1) - pCamX, (double)(boundingbox1.maxY() + 1) - p_113691_, (double)(boundingbox1.maxZ() + 1) - pCamY, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f);
                    continue;
                }
                LevelRenderer.renderLineBox(pPoseStack, vertexconsumer, (double)boundingbox1.minX() - pCamX, (double)boundingbox1.minY() - p_113691_, (double)boundingbox1.minZ() - pCamY, (double)(boundingbox1.maxX() + 1) - pCamX, (double)(boundingbox1.maxY() + 1) - p_113691_, (double)(boundingbox1.maxZ() + 1) - pCamY, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public void addBoundingBox(BoundingBox pPostMainBox, List<BoundingBox> pPieceBoxes, List<Boolean> pStartPieceFlags, DimensionType pDimensionType) {
        if (!this.postMainBoxes.containsKey(pDimensionType)) {
            this.postMainBoxes.put(pDimensionType, Maps.newHashMap());
        }
        if (!this.postPiecesBoxes.containsKey(pDimensionType)) {
            this.postPiecesBoxes.put(pDimensionType, Maps.newHashMap());
            this.startPiecesMap.put(pDimensionType, Maps.newHashMap());
        }
        this.postMainBoxes.get(pDimensionType).put(pPostMainBox.toString(), pPostMainBox);
        int i = 0;
        while (i < pPieceBoxes.size()) {
            BoundingBox boundingbox = pPieceBoxes.get(i);
            Boolean obool = pStartPieceFlags.get(i);
            this.postPiecesBoxes.get(pDimensionType).put(boundingbox.toString(), boundingbox);
            this.startPiecesMap.get(pDimensionType).put(boundingbox.toString(), obool);
            ++i;
        }
    }

    @Override
    public void clear() {
        this.postMainBoxes.clear();
        this.postPiecesBoxes.clear();
        this.startPiecesMap.clear();
    }
}

