/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;

public class VillageSectionsDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private static final int MAX_RENDER_DIST_FOR_VILLAGE_SECTIONS = 60;
    private final Set<SectionPos> villageSections = Sets.newHashSet();

    VillageSectionsDebugRenderer() {
    }

    @Override
    public void clear() {
        this.villageSections.clear();
    }

    public void setVillageSection(SectionPos pPos) {
        this.villageSections.add(pPos);
    }

    public void setNotVillageSection(SectionPos pPos) {
        this.villageSections.remove(pPos);
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113704_, double pCamY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        this.doRender(pCamX, p_113704_, pCamY);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    private void doRender(double pX, double p_113698_, double pY) {
        BlockPos blockpos = new BlockPos(pX, p_113698_, pY);
        this.villageSections.forEach(p_113708_ -> {
            if (blockpos.closerThan(p_113708_.center(), 60.0)) {
                VillageSectionsDebugRenderer.highlightVillageSection(p_113708_);
            }
        });
    }

    private static void highlightVillageSection(SectionPos pPos) {
        float f = 1.0f;
        BlockPos blockpos = pPos.center();
        BlockPos blockpos1 = blockpos.offset(-1.0, -1.0, -1.0);
        BlockPos blockpos2 = blockpos.offset(1.0, 1.0, 1.0);
        DebugRenderer.renderFilledBox(blockpos1, blockpos2, 0.2f, 1.0f, 0.2f, 0.15f);
    }
}

