/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;

public class WorldGenAttemptRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final List<BlockPos> toRender = Lists.newArrayList();
    private final List<Float> scales = Lists.newArrayList();
    private final List<Float> alphas = Lists.newArrayList();
    private final List<Float> reds = Lists.newArrayList();
    private final List<Float> greens = Lists.newArrayList();
    private final List<Float> blues = Lists.newArrayList();

    public void addPos(BlockPos pPos, float pScale, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.toRender.add(pPos);
        this.scales.add(Float.valueOf(pScale));
        this.alphas.add(Float.valueOf(pAlpha));
        this.reds.add(Float.valueOf(pRed));
        this.greens.add(Float.valueOf(pGreen));
        this.blues.add(Float.valueOf(pBlue));
    }

    @Override
    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, double pCamX, double p_113735_, double pCamY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        int i = 0;
        while (i < this.toRender.size()) {
            BlockPos blockpos = this.toRender.get(i);
            Float f = this.scales.get(i);
            float f1 = f.floatValue() / 2.0f;
            LevelRenderer.addChainedFilledBoxVertices(bufferbuilder, (double)((float)blockpos.getX() + 0.5f - f1) - pCamX, (double)((float)blockpos.getY() + 0.5f - f1) - p_113735_, (double)((float)blockpos.getZ() + 0.5f - f1) - pCamY, (double)((float)blockpos.getX() + 0.5f + f1) - pCamX, (double)((float)blockpos.getY() + 0.5f + f1) - p_113735_, (double)((float)blockpos.getZ() + 0.5f + f1) - pCamY, this.reds.get(i).floatValue(), this.greens.get(i).floatValue(), this.blues.get(i).floatValue(), this.alphas.get(i).floatValue());
            ++i;
        }
        tesselator.end();
        RenderSystem.enableTexture();
    }
}

