/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;

public abstract class ArrowRenderer<T extends AbstractArrow>
extends EntityRenderer<T> {
    public ArrowRenderer(EntityRendererProvider.Context p_173917_) {
        super(p_173917_);
    }

    @Override
    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(Mth.lerp(pPartialTicks, ((AbstractArrow)pEntity).yRotO, ((Entity)pEntity).getYRot()) - 90.0f));
        pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(Mth.lerp(pPartialTicks, ((AbstractArrow)pEntity).xRotO, ((Entity)pEntity).getXRot())));
        boolean i = false;
        float f = 0.0f;
        float f1 = 0.5f;
        float f2 = 0.0f;
        float f3 = 0.15625f;
        float f4 = 0.0f;
        float f5 = 0.15625f;
        float f6 = 0.15625f;
        float f7 = 0.3125f;
        float f8 = 0.05625f;
        float f9 = (float)((AbstractArrow)pEntity).shakeTime - pPartialTicks;
        if (f9 > 0.0f) {
            float f10 = -Mth.sin(f9 * 3.0f) * f9;
            pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(f10));
        }
        pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(45.0f));
        pMatrixStack.scale(0.05625f, 0.05625f, 0.05625f);
        pMatrixStack.translate(-4.0, 0.0, 0.0);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityCutout(this.getTextureLocation(pEntity)));
        PoseStack.Pose posestack$pose = pMatrixStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, pPackedLight);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, pPackedLight);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, pPackedLight);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, pPackedLight);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, pPackedLight);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, pPackedLight);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, pPackedLight);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, pPackedLight);
        int j = 0;
        while (j < 4) {
            pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(90.0f));
            this.vertex(matrix4f, matrix3f, vertexconsumer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, pPackedLight);
            this.vertex(matrix4f, matrix3f, vertexconsumer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, pPackedLight);
            this.vertex(matrix4f, matrix3f, vertexconsumer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, pPackedLight);
            this.vertex(matrix4f, matrix3f, vertexconsumer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, pPackedLight);
            ++j;
        }
        pMatrixStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public void vertex(Matrix4f p_113826_, Matrix3f p_113827_, VertexConsumer p_113828_, int p_113829_, int p_113830_, int p_113831_, float p_113832_, float p_113833_, int p_113834_, int p_113835_, int p_113836_, int p_113837_) {
        p_113828_.vertex(p_113826_, p_113829_, p_113830_, p_113831_).color(255, 255, 255, 255).uv(p_113832_, p_113833_).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(p_113837_).normal(p_113827_, p_113834_, p_113836_, p_113835_).endVertex();
    }
}

