/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;

public class BoatRenderer
extends EntityRenderer<Boat> {
    private final Map<Boat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public BoatRenderer(EntityRendererProvider.Context p_173936_) {
        super(p_173936_);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, p_173941_ -> Pair.of((Object)new ResourceLocation("textures/entity/boat/" + p_173941_.getName() + ".png"), (Object)new BoatModel(p_173936_.bakeLayer(ModelLayers.createBoatModelName(p_173941_))))));
    }

    @Override
    public void render(Boat pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.pushPose();
        pMatrixStack.translate(0.0, 0.375, 0.0);
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(180.0f - pEntityYaw));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(Mth.sin(f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        if (!Mth.equal(f2 = pEntity.getBubbleAngle(pPartialTicks), 0.0f)) {
            pMatrixStack.mulPose(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), pEntity.getBubbleAngle(pPartialTicks), true));
        }
        Pair<ResourceLocation, BoatModel> pair = this.boatResources.get((Object)pEntity.getBoatType());
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel boatmodel = (BoatModel)pair.getSecond();
        pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(90.0f));
        boatmodel.setupAnim(pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(boatmodel.renderType(resourcelocation));
        boatmodel.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!pEntity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = pBuffer.getBuffer(RenderType.waterMask());
            boatmodel.waterPatch().render(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.NO_OVERLAY);
        }
        pMatrixStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @Override
    public ResourceLocation getTextureLocation(Boat pEntity) {
        return (ResourceLocation)this.boatResources.get((Object)pEntity.getBoatType()).getFirst();
    }
}

