/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.CatCollarLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class CatRenderer
extends MobRenderer<Cat, CatModel<Cat>> {
    public CatRenderer(EntityRendererProvider.Context p_173943_) {
        super(p_173943_, new CatModel(p_173943_.bakeLayer(ModelLayers.CAT)), 0.4f);
        this.addLayer(new CatCollarLayer(this, p_173943_.getModelSet()));
    }

    @Override
    public ResourceLocation getTextureLocation(Cat pEntity) {
        return pEntity.getResourceLocation();
    }

    @Override
    protected void scale(Cat pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        super.scale(pLivingEntity, pMatrixStack, pPartialTickTime);
        pMatrixStack.scale(0.8f, 0.8f, 0.8f);
    }

    @Override
    protected void setupRotations(Cat pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.setupRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        float f = pEntityLiving.getLieDownAmount(pPartialTicks);
        if (f > 0.0f) {
            pMatrixStack.translate(0.4f * f, 0.15f * f, 0.1f * f);
            pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(Mth.rotLerp(f, 0.0f, 90.0f)));
            BlockPos blockpos = pEntityLiving.blockPosition();
            for (Player player : pEntityLiving.level.getEntitiesOfClass(Player.class, new AABB(blockpos).inflate(2.0, 2.0, 2.0))) {
                if (!player.isSleeping()) continue;
                pMatrixStack.translate(0.15f * f, 0.0, 0.0);
                break;
            }
        }
    }
}

