/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;

public class EndCrystalRenderer
extends EntityRenderer<EndCrystal> {
    private static final ResourceLocation END_CRYSTAL_LOCATION = new ResourceLocation("textures/entity/end_crystal/end_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull(END_CRYSTAL_LOCATION);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final String GLASS = "glass";
    private static final String BASE = "base";
    private final ModelPart cube;
    private final ModelPart glass;
    private final ModelPart base;

    public EndCrystalRenderer(EntityRendererProvider.Context p_173970_) {
        super(p_173970_);
        this.shadowRadius = 0.5f;
        ModelPart modelpart = p_173970_.bakeLayer(ModelLayers.END_CRYSTAL);
        this.glass = modelpart.getChilds(GLASS);
        this.cube = modelpart.getChilds("cube");
        this.base = modelpart.getChilds(BASE);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(GLASS, CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(BASE, CubeListBuilder.create().texOffs(0, 16).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f), PartPose.ZERO);
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void render(EndCrystal pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        float f = EndCrystalRenderer.getY(pEntity, pPartialTicks);
        float f1 = ((float)pEntity.time + pPartialTicks) * 3.0f;
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RENDER_TYPE);
        pMatrixStack.pushPose();
        pMatrixStack.scale(2.0f, 2.0f, 2.0f);
        pMatrixStack.translate(0.0, -0.5, 0.0);
        int i = OverlayTexture.NO_OVERLAY;
        if (pEntity.showsBottom()) {
            this.base.render(pMatrixStack, vertexconsumer, pPackedLight, i);
        }
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(f1));
        pMatrixStack.translate(0.0, 1.5f + f / 2.0f, 0.0);
        pMatrixStack.mulPose(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        this.glass.render(pMatrixStack, vertexconsumer, pPackedLight, i);
        float f2 = 0.875f;
        pMatrixStack.scale(0.875f, 0.875f, 0.875f);
        pMatrixStack.mulPose(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(f1));
        this.glass.render(pMatrixStack, vertexconsumer, pPackedLight, i);
        pMatrixStack.scale(0.875f, 0.875f, 0.875f);
        pMatrixStack.mulPose(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(f1));
        this.cube.render(pMatrixStack, vertexconsumer, pPackedLight, i);
        pMatrixStack.popPose();
        pMatrixStack.popPose();
        BlockPos blockpos = pEntity.getBeamTarget();
        if (blockpos != null) {
            float f3 = (float)blockpos.getX() + 0.5f;
            float f4 = (float)blockpos.getY() + 0.5f;
            float f5 = (float)blockpos.getZ() + 0.5f;
            float f6 = (float)((double)f3 - pEntity.getX());
            float f7 = (float)((double)f4 - pEntity.getY());
            float f8 = (float)((double)f5 - pEntity.getZ());
            pMatrixStack.translate(f6, f7, f8);
            EnderDragonRenderer.renderCrystalBeams(-f6, -f7 + f, -f8, pPartialTicks, pEntity.time, pMatrixStack, pBuffer, pPackedLight);
        }
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public static float getY(EndCrystal p_114159_, float p_114160_) {
        float f = (float)p_114159_.time + p_114160_;
        float f1 = Mth.sin(f * 0.2f) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    @Override
    public ResourceLocation getTextureLocation(EndCrystal pEntity) {
        return END_CRYSTAL_LOCATION;
    }

    @Override
    public boolean shouldRender(EndCrystal pLivingEntity, Frustum pCamera, double pCamX, double p_114172_, double pCamY) {
        return super.shouldRender(pLivingEntity, pCamera, pCamX, p_114172_, pCamY) || pLivingEntity.getBeamTarget() != null;
    }
}

