/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ExperienceOrb;
import net.optifine.Config;
import net.optifine.CustomColors;

public class ExperienceOrbRenderer
extends EntityRenderer<ExperienceOrb> {
    private static final ResourceLocation EXPERIENCE_ORB_LOCATION = new ResourceLocation("textures/entity/experience_orb.png");
    private static final RenderType RENDER_TYPE = RenderType.itemEntityTranslucentCull(EXPERIENCE_ORB_LOCATION);

    public ExperienceOrbRenderer(EntityRendererProvider.Context p_174110_) {
        super(p_174110_);
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    @Override
    protected int getBlockLightLevel(ExperienceOrb pEntity, BlockPos pPos) {
        return Mth.clamp(super.getBlockLightLevel(pEntity, pPos) + 7, 0, 15);
    }

    @Override
    public void render(ExperienceOrb pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        int l1;
        pMatrixStack.pushPose();
        int i = pEntity.getIcon();
        float f = (float)(i % 4 * 16 + 0) / 64.0f;
        float f1 = (float)(i % 4 * 16 + 16) / 64.0f;
        float f2 = (float)(i / 4 * 16 + 0) / 64.0f;
        float f3 = (float)(i / 4 * 16 + 16) / 64.0f;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        float f7 = 255.0f;
        float f8 = ((float)pEntity.tickCount + pPartialTicks) / 2.0f;
        if (Config.isCustomColors()) {
            f8 = CustomColors.getXpOrbTimer(f8);
        }
        int j = (int)((Mth.sin(f8 + 0.0f) + 1.0f) * 0.5f * 255.0f);
        int k = 255;
        int l = (int)((Mth.sin(f8 + 4.1887903f) + 1.0f) * 0.1f * 255.0f);
        pMatrixStack.translate(0.0, 0.1f, 0.0);
        pMatrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(180.0f));
        float f9 = 0.3f;
        pMatrixStack.scale(0.3f, 0.3f, 0.3f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RENDER_TYPE);
        PoseStack.Pose posestack$pose = pMatrixStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        int i1 = j;
        int j1 = 255;
        int k1 = l;
        if (Config.isCustomColors() && (l1 = CustomColors.getXpOrbColor(f8)) >= 0) {
            i1 = l1 >> 16 & 0xFF;
            j1 = l1 >> 8 & 0xFF;
            k1 = l1 >> 0 & 0xFF;
        }
        ExperienceOrbRenderer.vertex(vertexconsumer, matrix4f, matrix3f, -0.5f, -0.25f, i1, j1, k1, f, f3, pPackedLight);
        ExperienceOrbRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 0.5f, -0.25f, i1, j1, k1, f1, f3, pPackedLight);
        ExperienceOrbRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 0.5f, 0.75f, i1, j1, k1, f1, f2, pPackedLight);
        ExperienceOrbRenderer.vertex(vertexconsumer, matrix4f, matrix3f, -0.5f, 0.75f, i1, j1, k1, f, f2, pPackedLight);
        pMatrixStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    private static void vertex(VertexConsumer pBuffer, Matrix4f pMatrix, Matrix3f pMatrixNormal, float pX, float pY, int pRed, int pGreen, int pBlue, float pTexU, float pTexV, int pPackedLight) {
        pBuffer.vertex(pMatrix, pX, pY, 0.0f).color(pRed, pGreen, pBlue, 128).uv(pTexU, pTexV).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(pPackedLight).normal(pMatrixNormal, 0.0f, 1.0f, 0.0f).endVertex();
    }

    @Override
    public ResourceLocation getTextureLocation(ExperienceOrb pEntity) {
        return EXPERIENCE_ORB_LOCATION;
    }
}

