/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemEntityRenderer
extends EntityRenderer<ItemEntity> {
    private static final float ITEM_BUNDLE_OFFSET_SCALE = 0.15f;
    private static final int ITEM_COUNT_FOR_5_BUNDLE = 48;
    private static final int ITEM_COUNT_FOR_4_BUNDLE = 32;
    private static final int ITEM_COUNT_FOR_3_BUNDLE = 16;
    private static final int ITEM_COUNT_FOR_2_BUNDLE = 1;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_X = 0.0f;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_Y = 0.0f;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_Z = 0.09375f;
    private final ItemRenderer itemRenderer;
    private final Random random = new Random();

    public ItemEntityRenderer(EntityRendererProvider.Context p_174198_) {
        super(p_174198_);
        this.itemRenderer = p_174198_.getItemRenderer();
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    private int getRenderAmount(ItemStack pStack) {
        int i = 1;
        if (pStack.getCount() > 48) {
            i = 5;
        } else if (pStack.getCount() > 32) {
            i = 4;
        } else if (pStack.getCount() > 16) {
            i = 3;
        } else if (pStack.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    @Override
    public void render(ItemEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        ItemStack itemstack = pEntity.getItem();
        int i = itemstack.isEmpty() ? 187 : Item.getId(itemstack.getItem()) + itemstack.getDamageValue();
        this.random.setSeed(i);
        BakedModel bakedmodel = this.itemRenderer.getModel(itemstack, pEntity.level, null, pEntity.getId());
        boolean flag = bakedmodel.isGui3d();
        int j = this.getRenderAmount(itemstack);
        float f = 0.25f;
        float f1 = Mth.sin(((float)pEntity.getAge() + pPartialTicks) / 10.0f + pEntity.bobOffs) * 0.1f + 0.1f;
        if (!this.shouldBob()) {
            f1 = 0.0f;
        }
        float f2 = bakedmodel.getTransforms().getTransform((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).scale.y();
        pMatrixStack.translate(0.0, f1 + 0.25f * f2, 0.0);
        float f3 = pEntity.getSpin(pPartialTicks);
        pMatrixStack.mulPose(Vector3f.YP.rotation(f3));
        float f4 = bakedmodel.getTransforms().ground.scale.x();
        float f5 = bakedmodel.getTransforms().ground.scale.y();
        float f6 = bakedmodel.getTransforms().ground.scale.z();
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f * f4;
            float f8 = -0.0f * (float)(j - 1) * 0.5f * f5;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f * f6;
            pMatrixStack.translate(f7, f8, f9);
        }
        int k = 0;
        while (k < j) {
            pMatrixStack.pushPose();
            if (k > 0) {
                if (flag) {
                    float f11 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f13 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f10 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    if (!this.shouldSpreadItems()) {
                        f11 = 0.0f;
                        f13 = 0.0f;
                        f10 = 0.0f;
                    }
                    pMatrixStack.translate(f11, f13, f10);
                } else {
                    float f12 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float f14 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    if (!this.shouldSpreadItems()) {
                        f12 = 0.0f;
                        f14 = 0.0f;
                    }
                    pMatrixStack.translate(f12, f14, 0.0);
                }
            }
            this.itemRenderer.render(itemstack, ItemTransforms.TransformType.GROUND, false, pMatrixStack, pBuffer, pPackedLight, OverlayTexture.NO_OVERLAY, bakedmodel);
            pMatrixStack.popPose();
            if (!flag) {
                pMatrixStack.translate(0.0f * f4, 0.0f * f5, 0.09375f * f6);
            }
            ++k;
        }
        pMatrixStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @Override
    public ResourceLocation getTextureLocation(ItemEntity pEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    public boolean shouldBob() {
        return true;
    }
}

