/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;

public class ItemFrameRenderer<T extends ItemFrame>
extends EntityRenderer<T> {
    private static final ModelResourceLocation FRAME_LOCATION = new ModelResourceLocation("item_frame", "map=false");
    private static final ModelResourceLocation MAP_FRAME_LOCATION = new ModelResourceLocation("item_frame", "map=true");
    private static final ModelResourceLocation GLOW_FRAME_LOCATION = new ModelResourceLocation("glow_item_frame", "map=false");
    private static final ModelResourceLocation GLOW_MAP_FRAME_LOCATION = new ModelResourceLocation("glow_item_frame", "map=true");
    public static final int GLOW_FRAME_BRIGHTNESS = 5;
    public static final int BRIGHT_MAP_LIGHT_ADJUSTMENT = 30;
    private final Minecraft minecraft = Minecraft.getInstance();
    private final ItemRenderer itemRenderer;
    private static double itemRenderDistanceSq = 4096.0;
    private static boolean renderItemFrame = false;

    public ItemFrameRenderer(EntityRendererProvider.Context p_174204_) {
        super(p_174204_);
        this.itemRenderer = p_174204_.getItemRenderer();
    }

    @Override
    protected int getBlockLightLevel(T pEntity, BlockPos pPos) {
        return ((Entity)pEntity).getType() == EntityType.GLOW_ITEM_FRAME ? Math.max(5, super.getBlockLightLevel(pEntity, pPos)) : super.getBlockLightLevel(pEntity, pPos);
    }

    @Override
    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.pushPose();
        Direction direction = ((HangingEntity)pEntity).getDirection();
        Vec3 vec3 = this.getRenderOffset(pEntity, pPartialTicks);
        pMatrixStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
        double d0 = 0.46875;
        pMatrixStack.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(((Entity)pEntity).getXRot()));
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(180.0f - ((Entity)pEntity).getYRot()));
        boolean flag = ((Entity)pEntity).isInvisible();
        ItemStack itemstack = ((ItemFrame)pEntity).getItem();
        if (!flag) {
            BlockRenderDispatcher blockrenderdispatcher = this.minecraft.getBlockRenderer();
            ModelManager modelmanager = blockrenderdispatcher.getBlockModelShaper().getModelManager();
            ModelResourceLocation modelresourcelocation = this.getFrameModelResourceLoc(pEntity, itemstack);
            pMatrixStack.pushPose();
            pMatrixStack.translate(-0.5, -0.5, -0.5);
            blockrenderdispatcher.getModelRenderer().renderModel(pMatrixStack.last(), pBuffer.getBuffer(Sheets.solidBlockSheet()), null, modelmanager.getModel(modelresourcelocation), 1.0f, 1.0f, 1.0f, pPackedLight, OverlayTexture.NO_OVERLAY);
            pMatrixStack.popPose();
        }
        if (!itemstack.isEmpty()) {
            boolean flag1 = itemstack.getItem() instanceof MapItem;
            if (flag) {
                pMatrixStack.translate(0.0, 0.0, 0.5);
            } else {
                pMatrixStack.translate(0.0, 0.0, 0.4375);
            }
            int j = flag1 ? ((ItemFrame)pEntity).getRotation() % 4 * 2 : ((ItemFrame)pEntity).getRotation();
            pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees((float)j * 360.0f / 8.0f));
            if (!Reflector.postForgeBusEvent(Reflector.RenderItemInFrameEvent_Constructor, pEntity, this, pMatrixStack, pBuffer, pPackedLight)) {
                if (flag1) {
                    pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(180.0f));
                    float f = 0.0078125f;
                    pMatrixStack.scale(0.0078125f, 0.0078125f, 0.0078125f);
                    pMatrixStack.translate(-64.0, -64.0, 0.0);
                    Integer integer = MapItem.getMapId(itemstack);
                    MapItemSavedData mapitemsaveddata = MapItem.getSavedData(integer, ((ItemFrame)pEntity).level);
                    pMatrixStack.translate(0.0, 0.0, -1.0);
                    if (mapitemsaveddata != null) {
                        int i = this.getLightVal(pEntity, 15728850, pPackedLight);
                        this.minecraft.gameRenderer.getMapRenderer().render(pMatrixStack, pBuffer, integer, mapitemsaveddata, true, i);
                    }
                } else {
                    int k = this.getLightVal(pEntity, 0xF000F0, pPackedLight);
                    pMatrixStack.scale(0.5f, 0.5f, 0.5f);
                    renderItemFrame = true;
                    if (this.isRenderItem((ItemFrame)pEntity)) {
                        this.itemRenderer.renderStatic(itemstack, ItemTransforms.TransformType.FIXED, k, OverlayTexture.NO_OVERLAY, pMatrixStack, pBuffer, ((Entity)pEntity).getId());
                    }
                    renderItemFrame = false;
                }
            }
        }
        pMatrixStack.popPose();
    }

    private int getLightVal(T p_174209_, int p_174210_, int p_174211_) {
        return ((Entity)p_174209_).getType() == EntityType.GLOW_ITEM_FRAME ? p_174210_ : p_174211_;
    }

    private ModelResourceLocation getFrameModelResourceLoc(T p_174213_, ItemStack p_174214_) {
        boolean flag;
        boolean bl = flag = ((Entity)p_174213_).getType() == EntityType.GLOW_ITEM_FRAME;
        if (p_174214_.getItem() instanceof MapItem) {
            return flag ? GLOW_MAP_FRAME_LOCATION : MAP_FRAME_LOCATION;
        }
        return flag ? GLOW_FRAME_LOCATION : FRAME_LOCATION;
    }

    @Override
    public Vec3 getRenderOffset(T pEntity, float pPartialTicks) {
        return new Vec3((float)((HangingEntity)pEntity).getDirection().getStepX() * 0.3f, -0.25, (float)((HangingEntity)pEntity).getDirection().getStepZ() * 0.3f);
    }

    @Override
    public ResourceLocation getTextureLocation(T pEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    @Override
    protected boolean shouldShowName(T pEntity) {
        if (Minecraft.renderNames() && !((ItemFrame)pEntity).getItem().isEmpty() && ((ItemFrame)pEntity).getItem().hasCustomHoverName() && this.entityRenderDispatcher.crosshairPickEntity == pEntity) {
            float f;
            double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)pEntity);
            float f2 = f = ((Entity)pEntity).isDiscrete() ? 32.0f : 64.0f;
            return d0 < (double)(f * f);
        }
        return false;
    }

    @Override
    protected void renderNameTag(T pEntity, Component pDisplayName, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.renderNameTag(pEntity, ((ItemFrame)pEntity).getItem().getHoverName(), pMatrixStack, pBuffer, pPackedLight);
    }

    private boolean isRenderItem(ItemFrame itemFrame) {
        Entity entity;
        double d0;
        if (Shaders.isShadowPass) {
            return false;
        }
        return Config.zoomMode || !((d0 = itemFrame.distanceToSqr((entity = this.minecraft.getCameraEntity()).getX(), entity.getY(), entity.getZ())) > itemRenderDistanceSq);
    }

    public static void updateItemRenderDistance() {
        Minecraft minecraft = Minecraft.getInstance();
        double d0 = Config.limit(minecraft.options.fov, 1.0, 120.0);
        double d1 = Math.max(6.0 * (double)minecraft.getWindow().getScreenHeight() / d0, 16.0);
        itemRenderDistanceSq = d1 * d1;
    }

    public static boolean isRenderItemFrame() {
        return renderItemFrame;
    }
}

