/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.scores.Team;
import net.optifine.Config;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import org.slf4j.Logger;

public abstract class LivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float EYE_BED_OFFSET = 0.1f;
    public M model;
    protected final List<RenderLayer> layers = Lists.newArrayList();
    public float renderLimbSwing;
    public float renderLimbSwingAmount;
    public float renderAgeInTicks;
    public float renderHeadYaw;
    public float renderHeadPitch;
    public float renderPartialTicks;
    private static final ResourceLocation ICONS = new ResourceLocation("minecraft", "textures/gui/diamondclient/hearts/icons.png");
    public static final boolean animateModelLiving = Boolean.getBoolean("animate.model.living");
    private static boolean renderItemHead = false;

    public LivingEntityRenderer(EntityRendererProvider.Context p_174289_, M p_174290_, float p_174291_) {
        super(p_174289_);
        this.model = p_174290_;
        this.shadowRadius = p_174291_;
    }

    public final boolean addLayer(RenderLayer<T, M> pLayer) {
        return this.layers.add(pLayer);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    private void blit(PoseStack stack, int x, int y, int u, int v, int width, int height) {
        Matrix4f matrix = stack.last().pose();
        float texScale = 0.00390625f;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.vertex(matrix, x, y + height, 0.0f).uv((float)u * texScale, (float)(v + height) * texScale).endVertex();
        buffer.vertex(matrix, x + width, y + height, 0.0f).uv((float)(u + width) * texScale, (float)(v + height) * texScale).endVertex();
        buffer.vertex(matrix, x + width, y, 0.0f).uv((float)(u + width) * texScale, (float)v * texScale).endVertex();
        buffer.vertex(matrix, x, y, 0.0f).uv((float)u * texScale, (float)v * texScale).endVertex();
        tessellator.end();
    }

    @Override
    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity instanceof Player && !(pEntity instanceof LocalPlayer)) {
            Player player = (Player)pEntity;
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player.distanceToSqr(player) <= 1024.0) {
                pMatrixStack.pushPose();
                pMatrixStack.translate(0.0, (double)player.getBbHeight() + 0.8, 0.0);
                pMatrixStack.mulPose(minecraft.getEntityRenderDispatcher().cameraOrientation());
                pMatrixStack.scale(-0.025f, -0.025f, 0.025f);
                float health = player.getHealth();
                float absorption = player.getAbsorptionAmount();
                float maxHealth = player.getMaxHealth();
                int baseHearts = 10;
                int extraHearts = (int)((maxHealth - 20.0f) / 2.0f);
                int absorptionHearts = (int)(absorption / 2.0f);
                int totalHearts = baseHearts + extraHearts + absorptionHearts;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture(0, ICONS);
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                float totalHealth = health + absorption;
                int i = 0;
                while (i < totalHearts) {
                    boolean hasHalfHeart;
                    int x = i % 10 * 8 - (totalHearts > 10 ? 40 : totalHearts * 4);
                    int y = i / 10 * -10;
                    boolean isAbsorption = i >= baseHearts + extraHearts;
                    int bgU = isAbsorption ? 160 : 16;
                    int bgV = 0;
                    this.blit(pMatrixStack, x, y, bgU, bgV, 9, 9);
                    int fullU = isAbsorption ? 160 : 52;
                    int halfU = isAbsorption ? 169 : 61;
                    int v = 0;
                    float currentHealth = isAbsorption ? absorption : health;
                    int fullHearts = (int)(currentHealth / 2.0f);
                    boolean bl = hasHalfHeart = currentHealth % 2.0f >= 1.0f;
                    if (i < fullHearts) {
                        this.blit(pMatrixStack, x, y, fullU, v, 9, 9);
                    } else if (i == fullHearts && hasHalfHeart) {
                        this.blit(pMatrixStack, x, y, halfU, v, 9, 9);
                    }
                    ++i;
                }
                RenderSystem.disableBlend();
                pMatrixStack.popPose();
            }
        }
        if (!Reflector.RenderLivingEvent_Pre_Constructor.exists() || !Reflector.postForgeBusEvent(Reflector.RenderLivingEvent_Pre_Constructor, pEntity, this, Float.valueOf(pPartialTicks), pMatrixStack, pBuffer, pPackedLight)) {
            boolean flag3;
            boolean flag1;
            Direction direction;
            if (animateModelLiving) {
                ((LivingEntity)pEntity).animationSpeed = 1.0f;
            }
            pMatrixStack.pushPose();
            ((EntityModel)this.model).attackTime = this.getAttackAnim(pEntity, pPartialTicks);
            ((EntityModel)this.model).riding = ((Entity)pEntity).isPassenger();
            if (Reflector.IForgeEntity_shouldRiderSit.exists()) {
                ((EntityModel)this.model).riding = ((Entity)pEntity).isPassenger() && ((Entity)pEntity).getVehicle() != null && Reflector.callBoolean(((Entity)pEntity).getVehicle(), Reflector.IForgeEntity_shouldRiderSit, new Object[0]);
            }
            ((EntityModel)this.model).young = ((LivingEntity)pEntity).isBaby();
            float f = Mth.rotLerp(pPartialTicks, ((LivingEntity)pEntity).yBodyRotO, ((LivingEntity)pEntity).yBodyRot);
            float f1 = Mth.rotLerp(pPartialTicks, ((LivingEntity)pEntity).yHeadRotO, ((LivingEntity)pEntity).yHeadRot);
            float f2 = f1 - f;
            if (((EntityModel)this.model).riding && ((Entity)pEntity).getVehicle() instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)((Entity)pEntity).getVehicle();
                f = Mth.rotLerp(pPartialTicks, livingentity.yBodyRotO, livingentity.yBodyRot);
                f2 = f1 - f;
                float f3 = Mth.wrapDegrees(f2);
                if (f3 < -85.0f) {
                    f3 = -85.0f;
                }
                if (f3 >= 85.0f) {
                    f3 = 85.0f;
                }
                f = f1 - f3;
                if (f3 * f3 > 2500.0f) {
                    f += f3 * 0.2f;
                }
                f2 = f1 - f;
            }
            float f7 = Mth.lerp(pPartialTicks, ((LivingEntity)pEntity).xRotO, ((Entity)pEntity).getXRot());
            if (LivingEntityRenderer.isEntityUpsideDown(pEntity)) {
                f7 *= -1.0f;
                f2 *= -1.0f;
            }
            if (((Entity)pEntity).getPose() == Pose.SLEEPING && (direction = ((LivingEntity)pEntity).getBedOrientation()) != null) {
                float f4 = ((Entity)pEntity).getEyeHeight(Pose.STANDING) - 0.1f;
                pMatrixStack.translate((float)(-direction.getStepX()) * f4, 0.0, (float)(-direction.getStepZ()) * f4);
            }
            float f8 = this.getBob(pEntity, pPartialTicks);
            this.setupRotations(pEntity, pMatrixStack, f8, f, pPartialTicks);
            pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
            this.scale(pEntity, pMatrixStack, pPartialTicks);
            pMatrixStack.translate(0.0, -1.501f, 0.0);
            float f9 = 0.0f;
            float f5 = 0.0f;
            if (!((Entity)pEntity).isPassenger() && ((LivingEntity)pEntity).isAlive()) {
                f9 = Mth.lerp(pPartialTicks, ((LivingEntity)pEntity).animationSpeedOld, ((LivingEntity)pEntity).animationSpeed);
                f5 = ((LivingEntity)pEntity).animationPosition - ((LivingEntity)pEntity).animationSpeed * (1.0f - pPartialTicks);
                if (((LivingEntity)pEntity).isBaby()) {
                    f5 *= 3.0f;
                }
                if (f9 > 1.0f) {
                    f9 = 1.0f;
                }
            }
            ((EntityModel)this.model).prepareMobModel(pEntity, f5, f9, pPartialTicks);
            ((EntityModel)this.model).setupAnim(pEntity, f5, f9, f8, f2, f7);
            if (CustomEntityModels.isActive()) {
                this.renderLimbSwing = f5;
                this.renderLimbSwingAmount = f9;
                this.renderAgeInTicks = f8;
                this.renderHeadYaw = f2;
                this.renderHeadPitch = f7;
                this.renderPartialTicks = pPartialTicks;
            }
            boolean flag = Config.isShaders();
            Minecraft minecraft = Minecraft.getInstance();
            boolean flag2 = !(flag1 = this.isBodyVisible(pEntity)) && !((Entity)pEntity).isInvisibleTo(minecraft.player);
            RenderType rendertype = this.getRenderType(pEntity, flag1, flag2, flag3 = minecraft.shouldEntityAppearGlowing((Entity)pEntity));
            if (rendertype != null) {
                VertexConsumer vertexconsumer = pBuffer.getBuffer(rendertype);
                float f6 = this.getWhiteOverlayProgress(pEntity, pPartialTicks);
                if (flag) {
                    if (((LivingEntity)pEntity).hurtTime > 0 || ((LivingEntity)pEntity).deathTime > 0) {
                        Shaders.setEntityColor(1.0f, 0.0f, 0.0f, 0.3f);
                    }
                    if (f6 > 0.0f) {
                        Shaders.setEntityColor(f6, f6, f6, 0.5f);
                    }
                }
                int i = LivingEntityRenderer.getOverlayCoords(pEntity, f6);
                ((Model)this.model).renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, i, 1.0f, 1.0f, 1.0f, flag2 ? 0.15f : 1.0f);
            }
            if (!((Entity)pEntity).isSpectator()) {
                for (RenderLayer renderlayer : this.layers) {
                    if (renderlayer instanceof CustomHeadLayer) {
                        renderItemHead = true;
                    }
                    renderlayer.render(pMatrixStack, pBuffer, pPackedLight, pEntity, f5, f9, pPartialTicks, f8, f2, f7);
                    renderItemHead = false;
                }
            }
            if (Config.isShaders()) {
                Shaders.setEntityColor(0.0f, 0.0f, 0.0f, 0.0f);
            }
            pMatrixStack.popPose();
            super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
            if (Reflector.RenderLivingEvent_Post_Constructor.exists()) {
                Reflector.postForgeBusEvent(Reflector.RenderLivingEvent_Post_Constructor, pEntity, this, Float.valueOf(pPartialTicks), pMatrixStack, pBuffer, pPackedLight);
            }
        }
    }

    @Nullable
    protected RenderType getRenderType(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation(p_115322_);
        if (this.getLocationTextureCustom() != null) {
            resourcelocation = this.getLocationTextureCustom();
        }
        if (p_115324_) {
            return RenderType.itemEntityTranslucentCull(resourcelocation);
        }
        if (p_115323_) {
            return ((Model)this.model).renderType(resourcelocation);
        }
        if (p_115325_ && !Config.getMinecraft().levelRenderer.shouldShowEntityOutlines()) {
            return ((Model)this.model).renderType(resourcelocation);
        }
        return p_115325_ ? RenderType.outline(resourcelocation) : null;
    }

    public static int getOverlayCoords(LivingEntity pLivingEntity, float pU) {
        return OverlayTexture.pack(OverlayTexture.u(pU), OverlayTexture.v(pLivingEntity.hurtTime > 0 || pLivingEntity.deathTime > 0));
    }

    protected boolean isBodyVisible(T pLivingEntity) {
        return !((Entity)pLivingEntity).isInvisible();
    }

    private static float sleepDirectionToRotation(Direction pFacing) {
        switch (pFacing) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean isShaking(T p_115304_) {
        return ((Entity)p_115304_).isFullyFrozen();
    }

    protected void setupRotations(T pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        Pose pose;
        if (this.isShaking(pEntityLiving)) {
            pRotationYaw += (float)(Math.cos((double)((LivingEntity)pEntityLiving).tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = ((Entity)pEntityLiving).getPose()) != Pose.SLEEPING) {
            pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(180.0f - pRotationYaw));
        }
        if (((LivingEntity)pEntityLiving).deathTime > 0) {
            float f = ((float)((LivingEntity)pEntityLiving).deathTime + pPartialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt(f)) > 1.0f) {
                f = 1.0f;
            }
            pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(f * this.getFlipDegrees(pEntityLiving)));
        } else if (((LivingEntity)pEntityLiving).isAutoSpinAttack()) {
            pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(-90.0f - ((Entity)pEntityLiving).getXRot()));
            pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(((float)((LivingEntity)pEntityLiving).tickCount + pPartialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = ((LivingEntity)pEntityLiving).getBedOrientation();
            float f1 = direction != null ? LivingEntityRenderer.sleepDirectionToRotation(direction) : pRotationYaw;
            pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(f1));
            pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(this.getFlipDegrees(pEntityLiving)));
            pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(270.0f));
        } else if (LivingEntityRenderer.isEntityUpsideDown(pEntityLiving)) {
            pMatrixStack.translate(0.0, ((Entity)pEntityLiving).getBbHeight() + 0.1f, 0.0);
            pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(180.0f));
        }
    }

    protected float getAttackAnim(T pLivingBase, float pPartialTickTime) {
        return ((LivingEntity)pLivingBase).getAttackAnim(pPartialTickTime);
    }

    protected float getBob(T pLivingBase, float pPartialTicks) {
        return (float)((LivingEntity)pLivingBase).tickCount + pPartialTicks;
    }

    protected float getFlipDegrees(T pLivingEntity) {
        return 90.0f;
    }

    protected float getWhiteOverlayProgress(T pLivingEntity, float pPartialTicks) {
        return 0.0f;
    }

    protected void scale(T pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
    }

    @Override
    protected boolean shouldShowName(T pEntity) {
        boolean flag;
        float f;
        double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)pEntity);
        float f2 = f = ((Entity)pEntity).isDiscrete() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        boolean bl = flag = !((Entity)pEntity).isInvisibleTo(localplayer);
        if (pEntity != localplayer) {
            Team team = ((Entity)pEntity).getTeam();
            Team team1 = localplayer.getTeam();
            if (team != null) {
                Team.Visibility team$visibility = team.getNameTagVisibility();
                switch (team$visibility) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.isAlliedTo(team1) && (team.canSeeFriendlyInvisibles() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.isAlliedTo(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.renderNames() && pEntity != minecraft.getCameraEntity() && flag && !((Entity)pEntity).isVehicle();
    }

    public static boolean isEntityUpsideDown(LivingEntity p_194454_) {
        String s;
        if ((p_194454_ instanceof Player || p_194454_.hasCustomName()) && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting(p_194454_.getName().getString())) || "Grumm".equals(s))) {
            return !(p_194454_ instanceof Player) || ((Player)p_194454_).isModelPartShown(PlayerModelPart.CAPE);
        }
        return false;
    }

    public <T extends RenderLayer> T getLayer(Class<T> cls) {
        List<T> list = this.getLayers(cls);
        return (T)(list.isEmpty() ? null : (RenderLayer)list.get(0));
    }

    public <T extends RenderLayer> List<T> getLayers(Class<T> cls) {
        ArrayList<RenderLayer> list = new ArrayList<RenderLayer>();
        for (RenderLayer renderlayer : this.layers) {
            if (!cls.isInstance(renderlayer)) continue;
            list.add(renderlayer);
        }
        return list;
    }

    public void removeLayers(Class cls) {
        Iterator<RenderLayer> iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            RenderLayer renderlayer = iterator.next();
            if (!cls.isInstance(renderlayer)) continue;
            iterator.remove();
        }
    }

    public static boolean isRenderItemHead() {
        return renderItemHead;
    }
}

