/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.LavaSlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.MagmaCube;

public class MagmaCubeRenderer
extends MobRenderer<MagmaCube, LavaSlimeModel<MagmaCube>> {
    private static final ResourceLocation MAGMACUBE_LOCATION = new ResourceLocation("textures/entity/slime/magmacube.png");

    public MagmaCubeRenderer(EntityRendererProvider.Context p_174298_) {
        super(p_174298_, new LavaSlimeModel(p_174298_.bakeLayer(ModelLayers.MAGMA_CUBE)), 0.25f);
    }

    @Override
    protected int getBlockLightLevel(MagmaCube pEntity, BlockPos pPos) {
        return 15;
    }

    @Override
    public ResourceLocation getTextureLocation(MagmaCube pEntity) {
        return MAGMACUBE_LOCATION;
    }

    @Override
    protected void scale(MagmaCube pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        int i = pLivingEntity.getSize();
        float f = Mth.lerp(pPartialTickTime, pLivingEntity.oSquish, pLivingEntity.squish) / ((float)i * 0.5f + 1.0f);
        float f1 = 1.0f / (f + 1.0f);
        pMatrixStack.scale(f1 * (float)i, 1.0f / f1 * (float)i, f1 * (float)i);
    }
}

