/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MinecartRenderer<T extends AbstractMinecart>
extends EntityRenderer<T> {
    private static final ResourceLocation MINECART_LOCATION = new ResourceLocation("textures/entity/minecart.png");
    protected final EntityModel<T> model;

    public MinecartRenderer(EntityRendererProvider.Context p_174300_, ModelLayerLocation p_174301_) {
        super(p_174300_);
        this.shadowRadius = 0.7f;
        this.model = new MinecartModel(p_174300_.bakeLayer(p_174301_));
    }

    @Override
    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.pushPose();
        long i = (long)((Entity)pEntity).getId() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        pMatrixStack.translate(f, f1, f2);
        double d0 = Mth.lerp((double)pPartialTicks, ((AbstractMinecart)pEntity).xOld, ((Entity)pEntity).getX());
        double d1 = Mth.lerp((double)pPartialTicks, ((AbstractMinecart)pEntity).yOld, ((Entity)pEntity).getY());
        double d2 = Mth.lerp((double)pPartialTicks, ((AbstractMinecart)pEntity).zOld, ((Entity)pEntity).getZ());
        double d3 = 0.3f;
        Vec3 vec3 = ((AbstractMinecart)pEntity).getPos(d0, d1, d2);
        float f3 = Mth.lerp(pPartialTicks, ((AbstractMinecart)pEntity).xRotO, ((Entity)pEntity).getXRot());
        if (vec3 != null) {
            Vec3 vec31 = ((AbstractMinecart)pEntity).getPosOffs(d0, d1, d2, 0.3f);
            Vec3 vec32 = ((AbstractMinecart)pEntity).getPosOffs(d0, d1, d2, -0.3f);
            if (vec31 == null) {
                vec31 = vec3;
            }
            if (vec32 == null) {
                vec32 = vec3;
            }
            pMatrixStack.translate(vec3.x - d0, (vec31.y + vec32.y) / 2.0 - d1, vec3.z - d2);
            Vec3 vec33 = vec32.add(-vec31.x, -vec31.y, -vec31.z);
            if (vec33.length() != 0.0) {
                vec33 = vec33.normalize();
                pEntityYaw = (float)(Math.atan2(vec33.z, vec33.x) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec33.y) * 73.0);
            }
        }
        pMatrixStack.translate(0.0, 0.375, 0.0);
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(180.0f - pEntityYaw));
        pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(-f3));
        float f5 = (float)((AbstractMinecart)pEntity).getHurtTime() - pPartialTicks;
        float f6 = ((AbstractMinecart)pEntity).getDamage() - pPartialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(Mth.sin(f5) * f5 * f6 / 10.0f * (float)((AbstractMinecart)pEntity).getHurtDir()));
        }
        int j = ((AbstractMinecart)pEntity).getDisplayOffset();
        BlockState blockstate = ((AbstractMinecart)pEntity).getDisplayBlockState();
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            pMatrixStack.pushPose();
            float f4 = 0.75f;
            pMatrixStack.scale(0.75f, 0.75f, 0.75f);
            pMatrixStack.translate(-0.5, (float)(j - 8) / 16.0f, 0.5);
            pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(90.0f));
            this.renderMinecartContents(pEntity, pPartialTicks, blockstate, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.popPose();
        }
        pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(pEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(this.model.renderType(this.getTextureLocation(pEntity)));
        this.model.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        pMatrixStack.popPose();
    }

    @Override
    public ResourceLocation getTextureLocation(T pEntity) {
        return MINECART_LOCATION;
    }

    protected void renderMinecartContents(T pEntity, float pPartialTicks, BlockState pState, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(pState, pMatrixStack, pBuffer, pPackedLight, OverlayTexture.NO_OVERLAY);
    }
}

