/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.PandaModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.PandaHoldsItemLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Panda;

public class PandaRenderer
extends MobRenderer<Panda, PandaModel<Panda>> {
    private static final Map<Panda.Gene, ResourceLocation> TEXTURES = Util.make(Maps.newEnumMap(Panda.Gene.class), p_115647_ -> {
        p_115647_.put(Panda.Gene.NORMAL, new ResourceLocation("textures/entity/panda/panda.png"));
        p_115647_.put(Panda.Gene.LAZY, new ResourceLocation("textures/entity/panda/lazy_panda.png"));
        p_115647_.put(Panda.Gene.WORRIED, new ResourceLocation("textures/entity/panda/worried_panda.png"));
        p_115647_.put(Panda.Gene.PLAYFUL, new ResourceLocation("textures/entity/panda/playful_panda.png"));
        p_115647_.put(Panda.Gene.BROWN, new ResourceLocation("textures/entity/panda/brown_panda.png"));
        p_115647_.put(Panda.Gene.WEAK, new ResourceLocation("textures/entity/panda/weak_panda.png"));
        p_115647_.put(Panda.Gene.AGGRESSIVE, new ResourceLocation("textures/entity/panda/aggressive_panda.png"));
    });

    public PandaRenderer(EntityRendererProvider.Context p_174334_) {
        super(p_174334_, new PandaModel(p_174334_.bakeLayer(ModelLayers.PANDA)), 0.9f);
        this.addLayer(new PandaHoldsItemLayer(this));
    }

    @Override
    public ResourceLocation getTextureLocation(Panda pEntity) {
        return TEXTURES.getOrDefault((Object)pEntity.getVariant(), TEXTURES.get((Object)Panda.Gene.NORMAL));
    }

    @Override
    protected void setupRotations(Panda pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        float f8;
        float f6;
        super.setupRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        if (pEntityLiving.rollCounter > 0) {
            float f1;
            int i = pEntityLiving.rollCounter;
            int j = i + 1;
            float f = 7.0f;
            float f2 = f1 = pEntityLiving.isBaby() ? 0.3f : 0.8f;
            if (i < 8) {
                float f3 = (float)(90 * i) / 7.0f;
                float f4 = (float)(90 * j) / 7.0f;
                float f22 = this.getAngle(f3, f4, j, pPartialTicks, 8.0f);
                pMatrixStack.translate(0.0, (f1 + 0.2f) * (f22 / 90.0f), 0.0);
                pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(-f22));
            } else if (i < 16) {
                float f13 = ((float)i - 8.0f) / 7.0f;
                float f16 = 90.0f + 90.0f * f13;
                float f5 = 90.0f + 90.0f * ((float)j - 8.0f) / 7.0f;
                float f10 = this.getAngle(f16, f5, j, pPartialTicks, 16.0f);
                pMatrixStack.translate(0.0, f1 + 0.2f + (f1 - 0.2f) * (f10 - 90.0f) / 90.0f, 0.0);
                pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(-f10));
            } else if ((float)i < 24.0f) {
                float f14 = ((float)i - 16.0f) / 7.0f;
                float f17 = 180.0f + 90.0f * f14;
                float f19 = 180.0f + 90.0f * ((float)j - 16.0f) / 7.0f;
                float f11 = this.getAngle(f17, f19, j, pPartialTicks, 24.0f);
                pMatrixStack.translate(0.0, f1 + f1 * (270.0f - f11) / 90.0f, 0.0);
                pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(-f11));
            } else if (i < 32) {
                float f15 = ((float)i - 24.0f) / 7.0f;
                float f18 = 270.0f + 90.0f * f15;
                float f20 = 270.0f + 90.0f * ((float)j - 24.0f) / 7.0f;
                float f12 = this.getAngle(f18, f20, j, pPartialTicks, 32.0f);
                pMatrixStack.translate(0.0, f1 * ((360.0f - f12) / 90.0f), 0.0);
                pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(-f12));
            }
        }
        if ((f6 = pEntityLiving.getSitAmount(pPartialTicks)) > 0.0f) {
            pMatrixStack.translate(0.0, 0.8f * f6, 0.0);
            pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(Mth.lerp(f6, pEntityLiving.getXRot(), pEntityLiving.getXRot() + 90.0f)));
            pMatrixStack.translate(0.0, -1.0f * f6, 0.0);
            if (pEntityLiving.isScared()) {
                float f7 = (float)(Math.cos((double)pEntityLiving.tickCount * 1.25) * Math.PI * (double)0.05f);
                pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(f7));
                if (pEntityLiving.isBaby()) {
                    pMatrixStack.translate(0.0, 0.8f, 0.55f);
                }
            }
        }
        if ((f8 = pEntityLiving.getLieOnBackAmount(pPartialTicks)) > 0.0f) {
            float f9 = pEntityLiving.isBaby() ? 0.5f : 1.3f;
            pMatrixStack.translate(0.0, f9 * f8, 0.0);
            pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(Mth.lerp(f8, pEntityLiving.getXRot(), pEntityLiving.getXRot() + 180.0f)));
        }
    }

    private float getAngle(float p_115625_, float p_115626_, int p_115627_, float p_115628_, float p_115629_) {
        return (float)p_115627_ < p_115629_ ? Mth.lerp(p_115628_, p_115625_, p_115626_) : p_115625_;
    }
}

