/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.SalmonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Salmon;

public class SalmonRenderer
extends MobRenderer<Salmon, SalmonModel<Salmon>> {
    private static final ResourceLocation SALMON_LOCATION = new ResourceLocation("textures/entity/fish/salmon.png");

    public SalmonRenderer(EntityRendererProvider.Context p_174364_) {
        super(p_174364_, new SalmonModel(p_174364_.bakeLayer(ModelLayers.SALMON)), 0.4f);
    }

    @Override
    public ResourceLocation getTextureLocation(Salmon pEntity) {
        return SALMON_LOCATION;
    }

    @Override
    protected void setupRotations(Salmon pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.setupRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        float f = 1.0f;
        float f1 = 1.0f;
        if (!pEntityLiving.isInWater()) {
            f = 1.3f;
            f1 = 1.7f;
        }
        float f2 = f * 4.3f * Mth.sin(f1 * 0.6f * pAgeInTicks);
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(f2));
        pMatrixStack.translate(0.0, 0.0, -0.4f);
        if (!pEntityLiving.isInWater()) {
            pMatrixStack.translate(0.2f, 0.1f, 0.0);
            pMatrixStack.mulPose(Vector3f.ZP.rotationDegrees(90.0f));
        }
    }
}

