/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.ShulkerHeadLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ShulkerRenderer
extends MobRenderer<Shulker, ShulkerModel<Shulker>> {
    private static final ResourceLocation DEFAULT_TEXTURE_LOCATION = new ResourceLocation("textures/" + Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION.texture().getPath() + ".png");
    private static final ResourceLocation[] TEXTURE_LOCATION = (ResourceLocation[])Sheets.SHULKER_TEXTURE_LOCATION.stream().map(p_115919_ -> new ResourceLocation("textures/" + p_115919_.texture().getPath() + ".png")).toArray(ResourceLocation[]::new);

    public ShulkerRenderer(EntityRendererProvider.Context p_174370_) {
        super(p_174370_, new ShulkerModel(p_174370_.bakeLayer(ModelLayers.SHULKER)), 0.0f);
        this.addLayer(new ShulkerHeadLayer(this));
    }

    @Override
    public Vec3 getRenderOffset(Shulker pEntity, float pPartialTicks) {
        return pEntity.getRenderPosition(pPartialTicks).orElse(super.getRenderOffset(pEntity, pPartialTicks));
    }

    @Override
    public boolean shouldRender(Shulker pLivingEntity, Frustum pCamera, double pCamX, double p_115916_, double pCamY) {
        return super.shouldRender(pLivingEntity, pCamera, pCamX, p_115916_, pCamY) ? true : pLivingEntity.getRenderPosition(0.0f).filter(p_174374_ -> {
            EntityType<?> entitytype = pLivingEntity.getType();
            float f = entitytype.getHeight() / 2.0f;
            float f1 = entitytype.getWidth() / 2.0f;
            Vec3 vec3 = Vec3.atBottomCenterOf(pLivingEntity.blockPosition());
            return pCamera.isVisible(new AABB(p_174374_.x, p_174374_.y + (double)f, p_174374_.z, vec3.x, vec3.y + (double)f, vec3.z).inflate(f1, f, f1));
        }).isPresent();
    }

    @Override
    public ResourceLocation getTextureLocation(Shulker pEntity) {
        return ShulkerRenderer.getTextureLocation(pEntity.getColor());
    }

    public static ResourceLocation getTextureLocation(@Nullable DyeColor p_174376_) {
        return p_174376_ == null ? DEFAULT_TEXTURE_LOCATION : TEXTURE_LOCATION[p_174376_.getId()];
    }

    @Override
    protected void setupRotations(Shulker pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.setupRotations(pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw + 180.0f, pPartialTicks);
        pMatrixStack.translate(0.0, 0.5, 0.0);
        pMatrixStack.mulPose(pEntityLiving.getAttachFace().getOpposite().getRotation());
        pMatrixStack.translate(0.0, -0.5, 0.0);
    }
}

