/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Squid;

public class SquidRenderer<T extends Squid>
extends MobRenderer<T, SquidModel<T>> {
    private static final ResourceLocation SQUID_LOCATION = new ResourceLocation("textures/entity/squid/squid.png");

    public SquidRenderer(EntityRendererProvider.Context p_174406_, SquidModel<T> p_174407_) {
        super(p_174406_, p_174407_, 0.7f);
    }

    @Override
    public ResourceLocation getTextureLocation(T pEntity) {
        return SQUID_LOCATION;
    }

    @Override
    protected void setupRotations(T pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        float f = Mth.lerp(pPartialTicks, ((Squid)pEntityLiving).xBodyRotO, ((Squid)pEntityLiving).xBodyRot);
        float f1 = Mth.lerp(pPartialTicks, ((Squid)pEntityLiving).zBodyRotO, ((Squid)pEntityLiving).zBodyRot);
        pMatrixStack.translate(0.0, 0.5, 0.0);
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(180.0f - pRotationYaw));
        pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(f));
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(f1));
        pMatrixStack.translate(0.0, -1.2f, 0.0);
    }

    @Override
    protected float getBob(T pLivingBase, float pPartialTicks) {
        return Mth.lerp(pPartialTicks, ((Squid)pLivingBase).oldTentacleAngle, ((Squid)pLivingBase).tentacleAngle);
    }
}

