/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;

public class CarriedBlockLayer
extends RenderLayer<EnderMan, EndermanModel<EnderMan>> {
    public CarriedBlockLayer(RenderLayerParent<EnderMan, EndermanModel<EnderMan>> p_116626_) {
        super(p_116626_);
    }

    @Override
    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, EnderMan pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        BlockState blockstate = pLivingEntity.getCarriedBlock();
        if (blockstate != null) {
            pMatrixStack.pushPose();
            pMatrixStack.translate(0.0, 0.6875, -0.75);
            pMatrixStack.mulPose(Vector3f.XP.rotationDegrees(20.0f));
            pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(45.0f));
            pMatrixStack.translate(0.25, 0.1875, 0.25);
            float f = 0.5f;
            pMatrixStack.scale(-0.5f, -0.5f, 0.5f);
            pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(90.0f));
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockstate, pMatrixStack, pBuffer, pPackedLight, OverlayTexture.NO_OVERLAY);
            pMatrixStack.popPose();
        }
    }
}

