/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;

public class CustomHeadLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;

    public CustomHeadLayer(RenderLayerParent<T, M> p_174475_, EntityModelSet p_174476_) {
        this(p_174475_, p_174476_, 1.0f, 1.0f, 1.0f);
    }

    public CustomHeadLayer(RenderLayerParent<T, M> p_174478_, EntityModelSet p_174479_, float p_174480_, float p_174481_, float p_174482_) {
        super(p_174478_);
        this.scaleX = p_174480_;
        this.scaleY = p_174481_;
        this.scaleZ = p_174482_;
        this.skullModels = SkullBlockRenderer.createSkullRenderers(p_174479_);
    }

    @Override
    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack itemstack = ((LivingEntity)pLivingEntity).getItemBySlot(EquipmentSlot.HEAD);
        if (!itemstack.isEmpty()) {
            boolean flag;
            Item item = itemstack.getItem();
            pMatrixStack.pushPose();
            pMatrixStack.scale(this.scaleX, this.scaleY, this.scaleZ);
            boolean bl = flag = pLivingEntity instanceof Villager || pLivingEntity instanceof ZombieVillager;
            if (((LivingEntity)pLivingEntity).isBaby() && !(pLivingEntity instanceof Villager)) {
                float f = 2.0f;
                float f1 = 1.4f;
                pMatrixStack.translate(0.0, 0.03125, 0.0);
                pMatrixStack.scale(0.7f, 0.7f, 0.7f);
                pMatrixStack.translate(0.0, 1.0, 0.0);
            }
            ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(pMatrixStack);
            if (item instanceof BlockItem && ((BlockItem)item).getBlock() instanceof AbstractSkullBlock) {
                CompoundTag compoundtag;
                float f2 = 1.1875f;
                pMatrixStack.scale(1.1875f, -1.1875f, -1.1875f);
                if (flag) {
                    pMatrixStack.translate(0.0, 0.0625, 0.0);
                }
                GameProfile gameprofile = null;
                if (itemstack.hasTag() && (compoundtag = itemstack.getTag()).contains("SkullOwner", 10)) {
                    gameprofile = NbtUtils.readGameProfile(compoundtag.getCompound("SkullOwner"));
                }
                pMatrixStack.translate(-0.5, 0.0, -0.5);
                SkullBlock.Type skullblock$type = ((AbstractSkullBlock)((BlockItem)item).getBlock()).getType();
                SkullModelBase skullmodelbase = this.skullModels.get(skullblock$type);
                RenderType rendertype = SkullBlockRenderer.getRenderType(skullblock$type, gameprofile);
                SkullBlockRenderer.renderSkull(null, 180.0f, pLimbSwing, pMatrixStack, pBuffer, pPackedLight, skullmodelbase, rendertype);
            } else if (!(item instanceof ArmorItem) || ((ArmorItem)item).getSlot() != EquipmentSlot.HEAD) {
                CustomHeadLayer.translateToHead(pMatrixStack, flag);
                Minecraft.getInstance().getItemInHandRenderer().renderItem((LivingEntity)pLivingEntity, itemstack, ItemTransforms.TransformType.HEAD, false, pMatrixStack, pBuffer, pPackedLight);
            }
            pMatrixStack.popPose();
        }
    }

    public static void translateToHead(PoseStack p_174484_, boolean p_174485_) {
        float f = 0.625f;
        p_174484_.translate(0.0, -0.25, 0.0);
        p_174484_.mulPose(Vector3f.YP.rotationDegrees(180.0f));
        p_174484_.scale(0.625f, -0.625f, -0.625f);
        if (p_174485_) {
            p_174484_.translate(0.0, 0.1875, 0.0);
        }
    }
}

