/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ItemInHandLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public ItemInHandLayer(RenderLayerParent<T, M> p_117183_) {
        super(p_117183_);
    }

    @Override
    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack itemstack1;
        boolean flag = ((LivingEntity)pLivingEntity).getMainArm() == HumanoidArm.RIGHT;
        ItemStack itemstack = flag ? ((LivingEntity)pLivingEntity).getOffhandItem() : ((LivingEntity)pLivingEntity).getMainHandItem();
        ItemStack itemStack = itemstack1 = flag ? ((LivingEntity)pLivingEntity).getMainHandItem() : ((LivingEntity)pLivingEntity).getOffhandItem();
        if (!itemstack.isEmpty() || !itemstack1.isEmpty()) {
            pMatrixStack.pushPose();
            if (((EntityModel)this.getParentModel()).young) {
                float f = 0.5f;
                pMatrixStack.translate(0.0, 0.75, 0.0);
                pMatrixStack.scale(0.5f, 0.5f, 0.5f);
            }
            this.renderArmWithItem((LivingEntity)pLivingEntity, itemstack1, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, pMatrixStack, pBuffer, pPackedLight);
            this.renderArmWithItem((LivingEntity)pLivingEntity, itemstack, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.popPose();
        }
    }

    protected void renderArmWithItem(LivingEntity p_117185_, ItemStack p_117186_, ItemTransforms.TransformType p_117187_, HumanoidArm p_117188_, PoseStack p_117189_, MultiBufferSource p_117190_, int p_117191_) {
        if (!p_117186_.isEmpty()) {
            p_117189_.pushPose();
            ((ArmedModel)this.getParentModel()).translateToHand(p_117188_, p_117189_);
            p_117189_.mulPose(Vector3f.XP.rotationDegrees(-90.0f));
            p_117189_.mulPose(Vector3f.YP.rotationDegrees(180.0f));
            boolean flag = p_117188_ == HumanoidArm.LEFT;
            p_117189_.translate((float)(flag ? -1 : 1) / 16.0f, 0.125, -0.625);
            Minecraft.getInstance().getItemInHandRenderer().renderItem(p_117185_, p_117186_, p_117187_, flag, p_117189_, p_117190_, p_117191_);
            p_117189_.popPose();
        }
    }
}

