/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;

public class MushroomCowMushroomLayer<T extends MushroomCow>
extends RenderLayer<T, CowModel<T>> {
    private ModelPart modelRendererMushroom = new ModelPart(new ArrayList<ModelPart.Cube>(), new HashMap<String, ModelPart>());
    private static final ResourceLocation LOCATION_MUSHROOM_RED = new ResourceLocation("textures/entity/cow/red_mushroom.png");
    private static final ResourceLocation LOCATION_MUSHROOM_BROWN = new ResourceLocation("textures/entity/cow/brown_mushroom.png");
    private static boolean hasTextureMushroomRed = false;
    private static boolean hasTextureMushroomBrown = false;

    public MushroomCowMushroomLayer(RenderLayerParent<T, CowModel<T>> p_117243_) {
        super(p_117243_);
        this.modelRendererMushroom.setTextureSize(16, 16);
        this.modelRendererMushroom.x = 8.0f;
        this.modelRendererMushroom.z = 8.0f;
        this.modelRendererMushroom.yRot = 0.7853982f;
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[4];
        nArray[0] = 16;
        nArray[1] = 16;
        nArrayArray[2] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 16;
        nArray2[1] = 16;
        nArrayArray[3] = nArray2;
        int[][] aint = nArrayArray;
        this.modelRendererMushroom.addBox(aint, -10.0f, 0.0f, 0.0f, 20.0f, 16.0f, 0.0f, 0.0f);
        int[][] nArrayArray2 = new int[6][];
        int[] nArray3 = new int[4];
        nArray3[0] = 16;
        nArray3[1] = 16;
        nArrayArray2[4] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 16;
        nArray4[1] = 16;
        nArrayArray2[5] = nArray4;
        int[][] aint1 = nArrayArray2;
        this.modelRendererMushroom.addBox(aint1, 0.0f, 0.0f, -10.0f, 0.0f, 16.0f, 20.0f, 0.0f);
    }

    @Override
    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!((AgeableMob)pLivingEntity).isBaby()) {
            boolean flag;
            Minecraft minecraft = Minecraft.getInstance();
            boolean bl = flag = minecraft.shouldEntityAppearGlowing((Entity)pLivingEntity) && ((Entity)pLivingEntity).isInvisible();
            if (!((Entity)pLivingEntity).isInvisible() || flag) {
                BlockRenderDispatcher blockrenderdispatcher = minecraft.getBlockRenderer();
                BlockState blockstate = ((MushroomCow)pLivingEntity).getMushroomType().getBlockState();
                ResourceLocation resourcelocation = this.getCustomMushroom(blockstate);
                VertexConsumer vertexconsumer = null;
                if (resourcelocation != null) {
                    vertexconsumer = pBuffer.getBuffer(RenderType.entityCutout(resourcelocation));
                }
                int i = LivingEntityRenderer.getOverlayCoords(pLivingEntity, 0.0f);
                BakedModel bakedmodel = blockrenderdispatcher.getBlockModel(blockstate);
                pMatrixStack.pushPose();
                pMatrixStack.translate(0.2f, -0.35f, 0.5);
                pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(-48.0f));
                pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
                pMatrixStack.translate(-0.5, -0.5, -0.5);
                if (resourcelocation != null) {
                    this.modelRendererMushroom.render(pMatrixStack, vertexconsumer, pPackedLight, i);
                } else {
                    this.renderMushroomBlock(pMatrixStack, pBuffer, pPackedLight, flag, blockrenderdispatcher, blockstate, i, bakedmodel);
                }
                pMatrixStack.popPose();
                pMatrixStack.pushPose();
                pMatrixStack.translate(0.2f, -0.35f, 0.5);
                pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(42.0f));
                pMatrixStack.translate(0.1f, 0.0, -0.6f);
                pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(-48.0f));
                pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
                pMatrixStack.translate(-0.5, -0.5, -0.5);
                if (resourcelocation != null) {
                    this.modelRendererMushroom.render(pMatrixStack, vertexconsumer, pPackedLight, i);
                } else {
                    this.renderMushroomBlock(pMatrixStack, pBuffer, pPackedLight, flag, blockrenderdispatcher, blockstate, i, bakedmodel);
                }
                pMatrixStack.popPose();
                pMatrixStack.pushPose();
                ((CowModel)this.getParentModel()).getHead().translateAndRotate(pMatrixStack);
                pMatrixStack.translate(0.0, -0.7f, -0.2f);
                pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(-78.0f));
                pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
                pMatrixStack.translate(-0.5, -0.5, -0.5);
                if (resourcelocation != null) {
                    this.modelRendererMushroom.render(pMatrixStack, vertexconsumer, pPackedLight, i);
                } else {
                    this.renderMushroomBlock(pMatrixStack, pBuffer, pPackedLight, flag, blockrenderdispatcher, blockstate, i, bakedmodel);
                }
                pMatrixStack.popPose();
            }
        }
    }

    private void renderMushroomBlock(PoseStack p_174502_, MultiBufferSource p_174503_, int p_174504_, boolean p_174505_, BlockRenderDispatcher p_174506_, BlockState p_174507_, int p_174508_, BakedModel p_174509_) {
        if (p_174505_) {
            p_174506_.getModelRenderer().renderModel(p_174502_.last(), p_174503_.getBuffer(RenderType.outline(TextureAtlas.LOCATION_BLOCKS)), p_174507_, p_174509_, 0.0f, 0.0f, 0.0f, p_174504_, p_174508_);
        } else {
            p_174506_.renderSingleBlock(p_174507_, p_174502_, p_174503_, p_174504_, p_174508_);
        }
    }

    private ResourceLocation getCustomMushroom(BlockState iblockstate) {
        Block block = iblockstate.getBlock();
        if (block == Blocks.RED_MUSHROOM && hasTextureMushroomRed) {
            return LOCATION_MUSHROOM_RED;
        }
        return block == Blocks.BROWN_MUSHROOM && hasTextureMushroomBrown ? LOCATION_MUSHROOM_BROWN : null;
    }

    public static void update() {
        hasTextureMushroomRed = Config.hasResource(LOCATION_MUSHROOM_RED);
        hasTextureMushroomBrown = Config.hasResource(LOCATION_MUSHROOM_BROWN);
    }
}

