/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.optifine.Config;
import net.optifine.shaders.Shaders;

public class ParrotOnShoulderLayer<T extends Player>
extends RenderLayer<T, PlayerModel<T>> {
    private final ParrotModel model;

    public ParrotOnShoulderLayer(RenderLayerParent<T, PlayerModel<T>> p_174511_, EntityModelSet p_174512_) {
        super(p_174511_);
        this.model = new ParrotModel(p_174512_.bakeLayer(ModelLayers.PARROT));
    }

    @Override
    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.render(pMatrixStack, pBuffer, pPackedLight, pLivingEntity, pLimbSwing, pLimbSwingAmount, pNetHeadYaw, pHeadPitch, true);
        this.render(pMatrixStack, pBuffer, pPackedLight, pLivingEntity, pLimbSwing, pLimbSwingAmount, pNetHeadYaw, pHeadPitch, false);
    }

    private void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pNetHeadYaw, float pHeadPitch, boolean pLeftShoulder) {
        CompoundTag compoundtag = pLeftShoulder ? ((Player)pLivingEntity).getShoulderEntityLeft() : ((Player)pLivingEntity).getShoulderEntityRight();
        EntityType.byString(compoundtag.getString("id")).filter(entityTypeIn -> entityTypeIn == EntityType.PARROT).ifPresent(entityTypeIn -> {
            Entity entity = Config.getEntityRenderDispatcher().getRenderedEntity();
            if (pLivingEntity instanceof AbstractClientPlayer) {
                ShoulderRidingEntity entity1;
                AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)pLivingEntity;
                ShoulderRidingEntity shoulderRidingEntity = entity1 = pLeftShoulder ? abstractclientplayer.entityShoulderLeft : abstractclientplayer.entityShoulderRight;
                if (entity1 != null) {
                    Config.getEntityRenderDispatcher().setRenderedEntity(entity1);
                    if (Config.isShaders()) {
                        Shaders.nextEntity(entity1);
                    }
                }
            }
            pMatrixStack.pushPose();
            pMatrixStack.translate(pLeftShoulder ? (double)0.4f : (double)-0.4f, pLivingEntity.isCrouching() ? (double)-1.3f : -1.5, 0.0);
            VertexConsumer vertexconsumer = pBuffer.getBuffer(this.model.renderType(ParrotRenderer.PARROT_LOCATIONS[compoundtag.getInt("Variant")]));
            this.model.renderOnShoulder(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, pLimbSwing, pLimbSwingAmount, pNetHeadYaw, pHeadPitch, player.tickCount);
            pMatrixStack.popPose();
            Config.getEntityRenderDispatcher().setRenderedEntity(entity);
            if (Config.isShaders()) {
                Shaders.nextEntity(entity);
            }
        });
    }
}

