/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SnowGolemHeadLayer
extends RenderLayer<SnowGolem, SnowGolemModel<SnowGolem>> {
    public SnowGolemHeadLayer(RenderLayerParent<SnowGolem, SnowGolemModel<SnowGolem>> p_117481_) {
        super(p_117481_);
    }

    @Override
    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, SnowGolem pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (pLivingEntity.hasPumpkin()) {
            boolean flag;
            Minecraft minecraft = Minecraft.getInstance();
            boolean bl = flag = minecraft.shouldEntityAppearGlowing(pLivingEntity) && pLivingEntity.isInvisible();
            if (!pLivingEntity.isInvisible() || flag) {
                pMatrixStack.pushPose();
                ((SnowGolemModel)this.getParentModel()).getHead().translateAndRotate(pMatrixStack);
                float f = 0.625f;
                pMatrixStack.translate(0.0, -0.34375, 0.0);
                pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(180.0f));
                pMatrixStack.scale(0.625f, -0.625f, -0.625f);
                ItemStack itemstack = new ItemStack(Blocks.CARVED_PUMPKIN);
                if (flag) {
                    BlockState blockstate = Blocks.CARVED_PUMPKIN.defaultBlockState();
                    BlockRenderDispatcher blockrenderdispatcher = minecraft.getBlockRenderer();
                    BakedModel bakedmodel = blockrenderdispatcher.getBlockModel(blockstate);
                    int i = LivingEntityRenderer.getOverlayCoords(pLivingEntity, 0.0f);
                    pMatrixStack.translate(-0.5, -0.5, -0.5);
                    blockrenderdispatcher.getModelRenderer().renderModel(pMatrixStack.last(), pBuffer.getBuffer(RenderType.outline(TextureAtlas.LOCATION_BLOCKS)), blockstate, bakedmodel, 0.0f, 0.0f, 0.0f, pPackedLight, i);
                } else {
                    minecraft.getItemRenderer().renderStatic(pLivingEntity, itemstack, ItemTransforms.TransformType.HEAD, false, pMatrixStack, pBuffer, pLivingEntity.level, pPackedLight, LivingEntityRenderer.getOverlayCoords(pLivingEntity, 0.0f), pLivingEntity.getId());
                }
                pMatrixStack.popPose();
            }
        }
    }
}

