/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerHeadModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.metadata.animation.VillagerMetaDataSection;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;

public class VillagerProfessionLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final Int2ObjectMap<ResourceLocation> LEVEL_LOCATIONS = (Int2ObjectMap)Util.make(new Int2ObjectOpenHashMap(), p_117657_ -> {
        p_117657_.put(1, (Object)new ResourceLocation("stone"));
        p_117657_.put(2, (Object)new ResourceLocation("iron"));
        p_117657_.put(3, (Object)new ResourceLocation("gold"));
        p_117657_.put(4, (Object)new ResourceLocation("emerald"));
        p_117657_.put(5, (Object)new ResourceLocation("diamond"));
    });
    private final Object2ObjectMap<VillagerType, VillagerMetaDataSection.Hat> typeHatCache = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<VillagerProfession, VillagerMetaDataSection.Hat> professionHatCache = new Object2ObjectOpenHashMap();
    private final ResourceManager resourceManager;
    private final String path;

    public VillagerProfessionLayer(RenderLayerParent<T, M> p_174550_, ResourceManager p_174551_, String p_174552_) {
        super(p_174550_);
        this.resourceManager = p_174551_;
        this.path = p_174552_;
    }

    @Override
    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!((Entity)pLivingEntity).isInvisible()) {
            VillagerData villagerdata = ((VillagerDataHolder)pLivingEntity).getVillagerData();
            VillagerType villagertype = villagerdata.getType();
            VillagerProfession villagerprofession = villagerdata.getProfession();
            VillagerMetaDataSection.Hat villagermetadatasection$hat = this.getHatData(this.typeHatCache, "type", Registry.VILLAGER_TYPE, villagertype);
            VillagerMetaDataSection.Hat villagermetadatasection$hat1 = this.getHatData(this.professionHatCache, "profession", Registry.VILLAGER_PROFESSION, villagerprofession);
            Object m = this.getParentModel();
            ((VillagerHeadModel)m).hatVisible(villagermetadatasection$hat1 == VillagerMetaDataSection.Hat.NONE || villagermetadatasection$hat1 == VillagerMetaDataSection.Hat.PARTIAL && villagermetadatasection$hat != VillagerMetaDataSection.Hat.FULL);
            ResourceLocation resourcelocation = this.getResourceLocation("type", Registry.VILLAGER_TYPE.getKey(villagertype));
            VillagerProfessionLayer.renderColoredCutoutModel(m, resourcelocation, pMatrixStack, pBuffer, pPackedLight, pLivingEntity, 1.0f, 1.0f, 1.0f);
            ((VillagerHeadModel)m).hatVisible(true);
            if (villagerprofession != VillagerProfession.NONE && !((LivingEntity)pLivingEntity).isBaby()) {
                ResourceLocation resourcelocation1 = this.getResourceLocation("profession", Registry.VILLAGER_PROFESSION.getKey(villagerprofession));
                VillagerProfessionLayer.renderColoredCutoutModel(m, resourcelocation1, pMatrixStack, pBuffer, pPackedLight, pLivingEntity, 1.0f, 1.0f, 1.0f);
                if (villagerprofession != VillagerProfession.NITWIT) {
                    ResourceLocation resourcelocation2 = this.getResourceLocation("profession_level", (ResourceLocation)LEVEL_LOCATIONS.get(Mth.clamp(villagerdata.getLevel(), 1, LEVEL_LOCATIONS.size())));
                    VillagerProfessionLayer.renderColoredCutoutModel(m, resourcelocation2, pMatrixStack, pBuffer, pPackedLight, pLivingEntity, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    private ResourceLocation getResourceLocation(String p_117669_, ResourceLocation p_117670_) {
        return new ResourceLocation(p_117670_.getNamespace(), "textures/entity/" + this.path + "/" + p_117669_ + "/" + p_117670_.getPath() + ".png");
    }

    public <K> VillagerMetaDataSection.Hat getHatData(Object2ObjectMap<K, VillagerMetaDataSection.Hat> p_117659_, String p_117660_, DefaultedRegistry<K> p_117661_, K p_117662_) {
        return (VillagerMetaDataSection.Hat)((Object)p_117659_.computeIfAbsent(p_117662_, p_117667_ -> {
            try {
                VillagerMetaDataSection.Hat villagermetadatasection$hat;
                block9: {
                    block8: {
                        try (Resource resource = this.resourceManager.getResource(this.getResourceLocation(p_117660_, p_117661_.getKey(p_117662_)));){
                            VillagerMetaDataSection villagermetadatasection = resource.getMetadata(VillagerMetaDataSection.SERIALIZER);
                            if (villagermetadatasection == null) break block8;
                            villagermetadatasection$hat = villagermetadatasection.getHat();
                            break block9;
                        }
                    }
                    return VillagerMetaDataSection.Hat.NONE;
                }
                return villagermetadatasection$hat;
            }
            catch (IOException ioexception) {
                return VillagerMetaDataSection.Hat.NONE;
            }
        }));
    }
}

