/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.Util;
import net.optifine.Mipmaps;
import net.optifine.texture.IColorBlender;

public class MipmapGenerator {
    private static final int ALPHA_CUTOUT_CUTOFF = 96;
    private static final float[] POW22 = Util.make(new float[256], floatsIn -> {
        int i = 0;
        while (i < ((float[])floatsIn).length) {
            floatsIn[i] = (float)Math.pow((float)i / 255.0f, 2.2);
            ++i;
        }
    });

    private MipmapGenerator() {
    }

    public static NativeImage[] generateMipLevels(NativeImage pImage, int pMipLevel) {
        return MipmapGenerator.generateMipmaps(pImage, pMipLevel, null);
    }

    public static NativeImage[] generateMipmaps(NativeImage imageIn, int mipmapLevelsIn, IColorBlender colorBlender) {
        NativeImage[] anativeimage = new NativeImage[mipmapLevelsIn + 1];
        anativeimage[0] = imageIn;
        if (mipmapLevelsIn > 0) {
            boolean flag = false;
            int i = 1;
            while (i <= mipmapLevelsIn) {
                NativeImage nativeimage = anativeimage[i - 1];
                NativeImage nativeimage1 = new NativeImage(nativeimage.getWidth() >> 1, nativeimage.getHeight() >> 1, false);
                int j = nativeimage1.getWidth();
                int k = nativeimage1.getHeight();
                int l = 0;
                while (l < j) {
                    int i1 = 0;
                    while (i1 < k) {
                        if (colorBlender != null) {
                            nativeimage1.setPixelRGBA(l, i1, colorBlender.blend(nativeimage.getPixelRGBA(l * 2 + 0, i1 * 2 + 0), nativeimage.getPixelRGBA(l * 2 + 1, i1 * 2 + 0), nativeimage.getPixelRGBA(l * 2 + 0, i1 * 2 + 1), nativeimage.getPixelRGBA(l * 2 + 1, i1 * 2 + 1)));
                        } else {
                            nativeimage1.setPixelRGBA(l, i1, MipmapGenerator.alphaBlend(nativeimage.getPixelRGBA(l * 2 + 0, i1 * 2 + 0), nativeimage.getPixelRGBA(l * 2 + 1, i1 * 2 + 0), nativeimage.getPixelRGBA(l * 2 + 0, i1 * 2 + 1), nativeimage.getPixelRGBA(l * 2 + 1, i1 * 2 + 1), flag));
                        }
                        ++i1;
                    }
                    ++l;
                }
                anativeimage[i] = nativeimage1;
                ++i;
            }
        }
        return anativeimage;
    }

    private static int alphaBlend(int pCol0, int pCol1, int pCol2, int pCol3, boolean pTransparent) {
        return Mipmaps.alphaBlend(pCol0, pCol1, pCol2, pCol3);
    }

    private static int gammaBlend(int pCol0, int pCol1, int pCol2, int pCol3, int pBitOffset) {
        float f = MipmapGenerator.getPow22(pCol0 >> pBitOffset);
        float f1 = MipmapGenerator.getPow22(pCol1 >> pBitOffset);
        float f2 = MipmapGenerator.getPow22(pCol2 >> pBitOffset);
        float f3 = MipmapGenerator.getPow22(pCol3 >> pBitOffset);
        float f4 = (float)((double)((float)Math.pow((double)(f + f1 + f2 + f3) * 0.25, 0.45454545454545453)));
        return (int)((double)f4 * 255.0);
    }

    private static float getPow22(int pValue) {
        return POW22[pValue & 0xFF];
    }
}

