/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;

public final class MissingTextureAtlasSprite
extends TextureAtlasSprite {
    private static final int MISSING_IMAGE_WIDTH = 16;
    private static final int MISSING_IMAGE_HEIGHT = 16;
    private static final String MISSING_TEXTURE_NAME = "missingno";
    private static final ResourceLocation MISSING_TEXTURE_LOCATION = new ResourceLocation("missingno");
    @Nullable
    private static DynamicTexture missingTexture;
    private static final LazyLoadedValue<NativeImage> MISSING_IMAGE_DATA;
    private static final TextureAtlasSprite.Info INFO;

    static {
        MISSING_IMAGE_DATA = new LazyLoadedValue<NativeImage>(() -> {
            NativeImage nativeimage = new NativeImage(16, 16, false);
            int i = -16777216;
            int j = -524040;
            int k = 0;
            while (k < 16) {
                int l = 0;
                while (l < 16) {
                    if (k < 8 ^ l < 8) {
                        nativeimage.setPixelRGBA(l, k, -524040);
                    } else {
                        nativeimage.setPixelRGBA(l, k, -16777216);
                    }
                    ++l;
                }
                ++k;
            }
            nativeimage.untrack();
            return nativeimage;
        });
        INFO = new TextureAtlasSprite.Info(MISSING_TEXTURE_LOCATION, 16, 16, new AnimationMetadataSection((List<AnimationFrame>)ImmutableList.of((Object)new AnimationFrame(0, -1)), 16, 16, 1, false));
    }

    public MissingTextureAtlasSprite(TextureAtlas atlasTextureIn, TextureAtlasSprite.Info spriteInfoIn, int mipmapLevelIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn) {
        super(atlasTextureIn, spriteInfoIn, mipmapLevelIn, atlasWidthIn, atlasHeightIn, xIn, yIn, MissingTextureAtlasSprite.makeMissingImage(spriteInfoIn.width(), spriteInfoIn.height()));
    }

    private MissingTextureAtlasSprite(TextureAtlas pAtlas, int pMipLevel, int pStorageX, int pStorageY, int pX, int pY) {
        super(pAtlas, INFO, pMipLevel, pStorageX, pStorageY, pX, pY, MISSING_IMAGE_DATA.get());
    }

    public static MissingTextureAtlasSprite newInstance(TextureAtlas pAtlas, int pMipLevel, int pStorageX, int pStorageY, int pX, int pY) {
        return new MissingTextureAtlasSprite(pAtlas, pMipLevel, pStorageX, pStorageY, pX, pY);
    }

    public static ResourceLocation getLocation() {
        return MISSING_TEXTURE_LOCATION;
    }

    public static TextureAtlasSprite.Info info() {
        return INFO;
    }

    @Override
    public void close() {
        super.close();
    }

    public static DynamicTexture getTexture() {
        if (missingTexture == null) {
            missingTexture = new DynamicTexture(MISSING_IMAGE_DATA.get());
            Minecraft.getInstance().getTextureManager().register(MISSING_TEXTURE_LOCATION, (AbstractTexture)missingTexture);
        }
        return missingTexture;
    }

    private static NativeImage makeMissingImage(int width, int height) {
        int i = width / 2;
        int j = height / 2;
        NativeImage nativeimage = new NativeImage(width, height, false);
        int k = -16777216;
        int l = -524040;
        int i1 = 0;
        while (i1 < height) {
            int j1 = 0;
            while (j1 < width) {
                if (i1 < j ^ j1 < i) {
                    nativeimage.setPixelRGBA(j1, i1, l);
                } else {
                    nativeimage.setPixelRGBA(j1, i1, k);
                }
                ++j1;
            }
            ++i1;
        }
        return nativeimage;
    }
}

