/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.texture.DynamicTexture;

public class OverlayTexture
implements AutoCloseable {
    private static final int SIZE = 16;
    public static final int NO_WHITE_U = 0;
    public static final int RED_OVERLAY_V = 3;
    public static final int WHITE_OVERLAY_V = 10;
    public static final int NO_OVERLAY = OverlayTexture.pack(0, 10);
    private final DynamicTexture texture = new DynamicTexture(16, 16, false);

    public OverlayTexture() {
        NativeImage nativeimage = this.texture.getPixels();
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                if (i < 8) {
                    nativeimage.setPixelRGBA(j, i, -1308622593);
                } else {
                    int k = (int)((1.0f - (float)j / 15.0f * 0.75f) * 255.0f);
                    nativeimage.setPixelRGBA(j, i, k << 24 | 0xFFFFFF);
                }
                ++j;
            }
            ++i;
        }
        RenderSystem.activeTexture(33985);
        this.texture.bind();
        nativeimage.upload(0, 0, 0, 0, 0, nativeimage.getWidth(), nativeimage.getHeight(), false, true, false, false);
        RenderSystem.activeTexture(33984);
    }

    @Override
    public void close() {
        this.texture.close();
    }

    public void setupOverlayColor() {
        RenderSystem.setupOverlayColor(this.texture::getId, 16);
    }

    public static int u(float pU) {
        return (int)(pU * 15.0f);
    }

    public static int v(boolean pHurt) {
        return pHurt ? 3 : 10;
    }

    public static int pack(int pU, int pHurt) {
        return pU | pHurt << 16;
    }

    public static int pack(float pU, boolean pHurt) {
        return OverlayTexture.pack(OverlayTexture.u(pU), OverlayTexture.v(pHurt));
    }

    public void teardownOverlayColor() {
        RenderSystem.teardownOverlayColor();
    }
}

