/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.optifine.Config;
import net.optifine.EmissiveTextures;
import net.optifine.shaders.ShadersTex;
import org.slf4j.Logger;

public class SimpleTexture
extends AbstractTexture {
    static final Logger LOGGER = LogUtils.getLogger();
    protected final ResourceLocation location;
    private ResourceManager resourceManager;
    public ResourceLocation locationEmissive;
    public boolean isEmissive;

    public SimpleTexture(ResourceLocation pLocation) {
        this.location = pLocation;
    }

    @Override
    public void load(ResourceManager pResourceManager) throws IOException {
        boolean flag1;
        boolean flag;
        this.resourceManager = pResourceManager;
        TextureImage simpletexture$textureimage = this.getTextureImage(pResourceManager);
        simpletexture$textureimage.throwIfError();
        TextureMetadataSection texturemetadatasection = simpletexture$textureimage.getTextureMetadata();
        if (texturemetadatasection != null) {
            flag = texturemetadatasection.isBlur();
            flag1 = texturemetadatasection.isClamp();
        } else {
            flag = false;
            flag1 = false;
        }
        NativeImage nativeimage = simpletexture$textureimage.getImage();
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.doLoad(nativeimage, flag, flag1));
        } else {
            this.doLoad(nativeimage, flag, flag1);
        }
    }

    private void doLoad(NativeImage pImage, boolean pBlur, boolean pClamp) {
        TextureUtil.prepareImage(this.getId(), 0, pImage.getWidth(), pImage.getHeight());
        pImage.upload(0, 0, 0, 0, 0, pImage.getWidth(), pImage.getHeight(), pBlur, pClamp, false, true);
        if (Config.isShaders()) {
            ShadersTex.loadSimpleTextureNS(this.getId(), pImage, pBlur, pClamp, this.resourceManager, this.location, this.getMultiTexID());
        }
        if (EmissiveTextures.isActive()) {
            EmissiveTextures.loadTexture(this.location, this);
        }
    }

    protected TextureImage getTextureImage(ResourceManager pResourceManager) {
        return TextureImage.load(pResourceManager, this.location);
    }

    protected static class TextureImage
    implements Closeable {
        @Nullable
        private final TextureMetadataSection metadata;
        @Nullable
        private final NativeImage image;
        @Nullable
        private final IOException exception;

        public TextureImage(IOException pException) {
            this.exception = pException;
            this.metadata = null;
            this.image = null;
        }

        public TextureImage(@Nullable TextureMetadataSection pMetadata, NativeImage pImage) {
            this.exception = null;
            this.metadata = pMetadata;
            this.image = pImage;
        }

        public static TextureImage load(ResourceManager pResourceManager, ResourceLocation pLocation) {
            try {
                TextureImage simpletexture$textureimage;
                try (Resource resource = pResourceManager.getResource(pLocation);){
                    NativeImage nativeimage = NativeImage.read(resource.getInputStream());
                    TextureMetadataSection texturemetadatasection = null;
                    try {
                        texturemetadatasection = resource.getMetadata(TextureMetadataSection.SERIALIZER);
                    }
                    catch (RuntimeException runtimeexception) {
                        LOGGER.warn("Failed reading metadata of: {}", (Object)pLocation, (Object)runtimeexception);
                    }
                    simpletexture$textureimage = new TextureImage(texturemetadatasection, nativeimage);
                }
                return simpletexture$textureimage;
            }
            catch (IOException ioexception1) {
                return new TextureImage(ioexception1);
            }
        }

        @Nullable
        public TextureMetadataSection getTextureMetadata() {
            return this.metadata;
        }

        public NativeImage getImage() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.image;
        }

        @Override
        public void close() {
            if (this.image != null) {
                this.image.close();
            }
        }

        public void throwIfError() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

