/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.optifine.util.MathUtils;

public class Stitcher {
    private static final Comparator<Holder> HOLDER_COMPARATOR = Comparator.comparing(holderIn -> -holderIn.height).thenComparing(holderIn -> -holderIn.width).thenComparing(holderIn -> holderIn.spriteInfo.name());
    private final int mipLevel;
    private final Set<Holder> texturesToBeStitched = Sets.newHashSetWithExpectedSize((int)256);
    private final List<Region> storage = Lists.newArrayListWithCapacity((int)256);
    private int storageX;
    private int storageY;
    private final int maxWidth;
    private final int maxHeight;

    public Stitcher(int pMaxWidth, int pMaxHeight, int pMipLevel) {
        this.mipLevel = pMipLevel;
        this.maxWidth = pMaxWidth;
        this.maxHeight = pMaxHeight;
    }

    public int getWidth() {
        return this.storageX;
    }

    public int getHeight() {
        return this.storageY;
    }

    public void registerSprite(TextureAtlasSprite.Info pSpriteInfo) {
        Holder stitcher$holder = new Holder(pSpriteInfo, this.mipLevel);
        this.texturesToBeStitched.add(stitcher$holder);
    }

    public void stitch() {
        ArrayList list = Lists.newArrayList(this.texturesToBeStitched);
        list.sort(HOLDER_COMPARATOR);
        for (Holder stitcher$holder : list) {
            if (this.addToStorage(stitcher$holder)) continue;
            throw new StitcherException(stitcher$holder.spriteInfo, (Collection)list.stream().map(holderIn -> holderIn.spriteInfo).collect(ImmutableList.toImmutableList()), this.storageX, this.storageY, this.maxWidth, this.maxHeight);
        }
        this.storageX = Mth.smallestEncompassingPowerOfTwo(this.storageX);
        this.storageY = Mth.smallestEncompassingPowerOfTwo(this.storageY);
    }

    public void gatherSprites(SpriteLoader pLoader) {
        for (Region stitcher$region : this.storage) {
            stitcher$region.walk(regionIn -> {
                Holder stitcher$holder = regionIn.getHolder();
                TextureAtlasSprite.Info textureatlassprite$info = stitcher$holder.spriteInfo;
                pLoader.load(textureatlassprite$info, this.storageX, this.storageY, regionIn.getX(), regionIn.getY());
            });
        }
    }

    static int smallestFittingMinTexel(int pDimension, int pMipLevel) {
        return (pDimension >> pMipLevel) + ((pDimension & (1 << pMipLevel) - 1) == 0 ? 0 : 1) << pMipLevel;
    }

    private boolean addToStorage(Holder pHolder) {
        for (Region stitcher$region : this.storage) {
            if (!stitcher$region.add(pHolder)) continue;
            return true;
        }
        return this.expand(pHolder);
    }

    private boolean expand(Holder pHolder) {
        Region stitcher$region;
        boolean flag2;
        boolean flag1;
        int i = Mth.smallestEncompassingPowerOfTwo(this.storageX);
        int j = Mth.smallestEncompassingPowerOfTwo(this.storageY);
        int k = Mth.smallestEncompassingPowerOfTwo(this.storageX + pHolder.width);
        int l = Mth.smallestEncompassingPowerOfTwo(this.storageY + pHolder.height);
        boolean flag = k <= this.maxWidth;
        boolean bl = flag1 = l <= this.maxHeight;
        if (!flag && !flag1) {
            return false;
        }
        int i1 = MathUtils.roundDownToPowerOfTwo(this.storageY);
        boolean bl2 = flag2 = flag && k <= 2 * i1;
        if (this.storageX == 0 && this.storageY == 0) {
            flag2 = true;
        }
        if (flag2) {
            if (this.storageY == 0) {
                this.storageY = pHolder.height;
            }
            stitcher$region = new Region(this.storageX, 0, pHolder.width, this.storageY);
            this.storageX += pHolder.width;
        } else {
            stitcher$region = new Region(0, this.storageY, this.storageX, pHolder.height);
            this.storageY += pHolder.height;
        }
        stitcher$region.add(pHolder);
        this.storage.add(stitcher$region);
        return true;
    }

    static class Holder {
        public final TextureAtlasSprite.Info spriteInfo;
        public final int width;
        public final int height;

        public Holder(TextureAtlasSprite.Info pSpriteInfo, int pMipLevel) {
            this.spriteInfo = pSpriteInfo;
            this.width = Stitcher.smallestFittingMinTexel(pSpriteInfo.width(), pMipLevel);
            this.height = Stitcher.smallestFittingMinTexel(pSpriteInfo.height(), pMipLevel);
        }

        public String toString() {
            return "Holder{width=" + this.width + ", height=" + this.height + ", name=" + this.spriteInfo.name() + "}";
        }
    }

    public static class Region {
        private final int originX;
        private final int originY;
        private final int width;
        private final int height;
        private List<Region> subSlots;
        private Holder holder;

        public Region(int pOriginX, int pOriginY, int pWidth, int pHeight) {
            this.originX = pOriginX;
            this.originY = pOriginY;
            this.width = pWidth;
            this.height = pHeight;
        }

        public Holder getHolder() {
            return this.holder;
        }

        public int getX() {
            return this.originX;
        }

        public int getY() {
            return this.originY;
        }

        public boolean add(Holder pHolder) {
            if (this.holder != null) {
                return false;
            }
            int i = pHolder.width;
            int j = pHolder.height;
            if (i <= this.width && j <= this.height) {
                if (i == this.width && j == this.height) {
                    this.holder = pHolder;
                    return true;
                }
                if (this.subSlots == null) {
                    this.subSlots = Lists.newArrayListWithCapacity((int)1);
                    this.subSlots.add(new Region(this.originX, this.originY, i, j));
                    int k = this.width - i;
                    int l = this.height - j;
                    if (l > 0 && k > 0) {
                        int j1;
                        int i1 = Math.max(this.height, k);
                        if (i1 >= (j1 = Math.max(this.width, l))) {
                            this.subSlots.add(new Region(this.originX, this.originY + j, i, l));
                            this.subSlots.add(new Region(this.originX + i, this.originY, k, this.height));
                        } else {
                            this.subSlots.add(new Region(this.originX + i, this.originY, k, j));
                            this.subSlots.add(new Region(this.originX, this.originY + j, this.width, l));
                        }
                    } else if (k == 0) {
                        this.subSlots.add(new Region(this.originX, this.originY + j, i, l));
                    } else if (l == 0) {
                        this.subSlots.add(new Region(this.originX + i, this.originY, k, j));
                    }
                }
                for (Region stitcher$region : this.subSlots) {
                    if (!stitcher$region.add(pHolder)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public void walk(Consumer<Region> pConsumer) {
            if (this.holder != null) {
                pConsumer.accept(this);
            } else if (this.subSlots != null) {
                for (Region stitcher$region : this.subSlots) {
                    stitcher$region.walk(pConsumer);
                }
            }
        }

        public String toString() {
            return "Slot{originX=" + this.originX + ", originY=" + this.originY + ", width=" + this.width + ", height=" + this.height + ", texture=" + this.holder + ", subSlots=" + this.subSlots + "}";
        }
    }

    public static interface SpriteLoader {
        public void load(TextureAtlasSprite.Info var1, int var2, int var3, int var4, int var5);
    }
}

