/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.AssetIndex;
import net.minecraft.client.resources.DefaultClientPackResources;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.util.HttpUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;

public class ClientPackSource
implements RepositorySource {
    private static final PackMetadataSection BUILT_IN = new PackMetadataSection(new TranslatableComponent("resourcePack.vanilla.description"), PackType.CLIENT_RESOURCES.getVersion(SharedConstants.getCurrentVersion()));
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final int MAX_PACK_SIZE_BYTES = 0xFA00000;
    private static final int MAX_KEPT_PACKS = 10;
    private static final String VANILLA_ID = "vanilla";
    private static final String SERVER_ID = "server";
    private static final String PROGRAMMER_ART_ID = "programer_art";
    private static final String PROGRAMMER_ART_NAME = "Programmer Art";
    private static final Component APPLYING_PACK_TEXT = new TranslatableComponent("multiplayer.applyingPack");
    private final VanillaPackResources vanillaPack;
    private final File serverPackDir;
    private final ReentrantLock downloadLock = new ReentrantLock();
    private final AssetIndex assetIndex;
    @Nullable
    private CompletableFuture<?> currentDownload;
    @Nullable
    private Pack serverPack;

    public ClientPackSource(File pServerPackDir, AssetIndex pAssetIndex) {
        this.serverPackDir = pServerPackDir;
        this.assetIndex = pAssetIndex;
        this.vanillaPack = new DefaultClientPackResources(BUILT_IN, pAssetIndex);
    }

    @Override
    public void loadPacks(Consumer<Pack> pInfoConsumer, Pack.PackConstructor pInfoFactory) {
        Pack pack1;
        Pack pack = Pack.create(VANILLA_ID, true, () -> this.vanillaPack, pInfoFactory, Pack.Position.BOTTOM, PackSource.BUILT_IN);
        if (pack != null) {
            pInfoConsumer.accept(pack);
        }
        if (this.serverPack != null) {
            pInfoConsumer.accept(this.serverPack);
        }
        if ((pack1 = this.createProgrammerArtPack(pInfoFactory)) != null) {
            pInfoConsumer.accept(pack1);
        }
    }

    public VanillaPackResources getVanillaPack() {
        return this.vanillaPack;
    }

    private static Map<String, String> getDownloadHeaders() {
        HashMap map = Maps.newHashMap();
        map.put("X-Minecraft-Username", Minecraft.getInstance().getUser().getName());
        map.put("X-Minecraft-UUID", Minecraft.getInstance().getUser().getUuid());
        map.put("X-Minecraft-Version", SharedConstants.getCurrentVersion().getName());
        map.put("X-Minecraft-Version-ID", SharedConstants.getCurrentVersion().getId());
        map.put("X-Minecraft-Pack-Format", String.valueOf(PackType.CLIENT_RESOURCES.getVersion(SharedConstants.getCurrentVersion())));
        map.put("User-Agent", "Minecraft Java/" + SharedConstants.getCurrentVersion().getName());
        return map;
    }

    public CompletableFuture<?> downloadAndSelectResourcePack(String p_174814_, String p_174815_, boolean p_174816_) {
        CompletableFuture<?> completablefuture1;
        String s = Hashing.sha1().hashString((CharSequence)p_174814_, StandardCharsets.UTF_8).toString();
        String s1 = SHA1.matcher(p_174815_).matches() ? p_174815_ : "";
        this.downloadLock.lock();
        try {
            CompletableFuture<String> completablefuture;
            this.clearServerPack();
            this.clearOldDownloads();
            File file1 = new File(this.serverPackDir, s);
            if (file1.exists()) {
                completablefuture = CompletableFuture.completedFuture("");
            } else {
                ProgressScreen progressscreen = new ProgressScreen(p_174816_);
                Map<String, String> map = ClientPackSource.getDownloadHeaders();
                Minecraft minecraft = Minecraft.getInstance();
                minecraft.executeBlocking(() -> minecraft.setScreen(progressscreen));
                completablefuture = HttpUtil.downloadTo(file1, p_174814_, map, 0xFA00000, progressscreen, minecraft.getProxy());
            }
            completablefuture1 = this.currentDownload = ((CompletableFuture)completablefuture.thenCompose(p_174812_ -> {
                if (!this.checkHash(s1, file1)) {
                    return Util.failedFuture(new RuntimeException("Hash check failure for file " + file1 + ", see log"));
                }
                Minecraft minecraft1 = Minecraft.getInstance();
                minecraft1.execute(() -> {
                    if (!p_174816_) {
                        minecraft1.setScreen(new GenericDirtMessageScreen(APPLYING_PACK_TEXT));
                    }
                });
                return this.setServerPack(file1, PackSource.SERVER);
            })).whenComplete((p_174806_, p_174807_) -> {
                if (p_174807_ != null) {
                    LOGGER.warn("Pack application failed: {}, deleting file {}", (Object)p_174807_.getMessage(), (Object)file1);
                    ClientPackSource.deleteQuietly(file1);
                    Minecraft minecraft1 = Minecraft.getInstance();
                    minecraft1.execute(() -> minecraft1.setScreen(new ConfirmScreen(p_174803_ -> {
                        if (p_174803_) {
                            minecraft1.setScreen(null);
                        } else {
                            ClientPacketListener clientpacketlistener = minecraft1.getConnection();
                            if (clientpacketlistener != null) {
                                clientpacketlistener.getConnection().disconnect(new TranslatableComponent("connect.aborted"));
                            }
                        }
                    }, new TranslatableComponent("multiplayer.texturePrompt.failure.line1"), new TranslatableComponent("multiplayer.texturePrompt.failure.line2"), CommonComponents.GUI_PROCEED, new TranslatableComponent("menu.disconnect"))));
                }
            });
        }
        finally {
            this.downloadLock.unlock();
        }
        return completablefuture1;
    }

    private static void deleteQuietly(File pFile) {
        try {
            Files.delete(pFile.toPath());
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to delete file {}: {}", (Object)pFile, (Object)ioexception.getMessage());
        }
    }

    public void clearServerPack() {
        this.downloadLock.lock();
        try {
            if (this.currentDownload != null) {
                this.currentDownload.cancel(true);
            }
            this.currentDownload = null;
            if (this.serverPack != null) {
                this.serverPack = null;
                Minecraft.getInstance().delayTextureReload();
            }
        }
        finally {
            this.downloadLock.unlock();
        }
    }

    private boolean checkHash(String pExpectedHash, File pFile) {
        String s;
        block5: {
            block4: {
                s = com.google.common.io.Files.asByteSource((File)pFile).hash(Hashing.sha1()).toString();
                if (!pExpectedHash.isEmpty()) break block4;
                LOGGER.info("Found file {} without verification hash", (Object)pFile);
                return true;
            }
            if (!s.toLowerCase(Locale.ROOT).equals(pExpectedHash.toLowerCase(Locale.ROOT))) break block5;
            LOGGER.info("Found file {} matching requested hash {}", (Object)pFile, (Object)pExpectedHash);
            return true;
        }
        try {
            LOGGER.warn("File {} had wrong hash (expected {}, found {}).", new Object[]{pFile, pExpectedHash, s});
        }
        catch (IOException ioexception) {
            LOGGER.warn("File {} couldn't be hashed.", (Object)pFile, (Object)ioexception);
        }
        return false;
    }

    private void clearOldDownloads() {
        if (this.serverPackDir.isDirectory()) {
            try {
                ArrayList list = Lists.newArrayList((Iterable)FileUtils.listFiles((File)this.serverPackDir, (IOFileFilter)TrueFileFilter.TRUE, null));
                list.sort(LastModifiedFileComparator.LASTMODIFIED_REVERSE);
                int i = 0;
                for (File file1 : list) {
                    if (i++ < 10) continue;
                    LOGGER.info("Deleting old server resource pack {}", (Object)file1.getName());
                    FileUtils.deleteQuietly((File)file1);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error while deleting old server resource pack : {}", (Object)exception.getMessage());
            }
        }
    }

    public CompletableFuture<Void> setServerPack(File pFile, PackSource pPackSource) {
        PackMetadataSection packmetadatasection;
        try (FilePackResources filepackresources = new FilePackResources(pFile);){
            packmetadatasection = filepackresources.getMetadataSection(PackMetadataSection.SERIALIZER);
        }
        catch (IOException ioexception) {
            return Util.failedFuture(new IOException(String.format("Invalid resourcepack at %s", pFile), ioexception));
        }
        LOGGER.info("Applying server pack {}", (Object)pFile);
        this.serverPack = new Pack(SERVER_ID, true, () -> new FilePackResources(pFile), new TranslatableComponent("resourcePack.server.name"), packmetadatasection.getDescription(), PackCompatibility.forMetadata(packmetadatasection, PackType.CLIENT_RESOURCES), Pack.Position.TOP, true, pPackSource);
        return Minecraft.getInstance().delayTextureReload();
    }

    @Nullable
    private Pack createProgrammerArtPack(Pack.PackConstructor pPackConstructor) {
        File file2;
        Pack pack = null;
        File file1 = this.assetIndex.getFile(new ResourceLocation("resourcepacks/programmer_art.zip"));
        if (file1 != null && file1.isFile()) {
            pack = ClientPackSource.createProgrammerArtPack(pPackConstructor, () -> ClientPackSource.createProgrammerArtZipPack(file1));
        }
        if (pack == null && SharedConstants.IS_RUNNING_IN_IDE && (file2 = this.assetIndex.getRootFile("../resourcepacks/programmer_art")) != null && file2.isDirectory()) {
            pack = ClientPackSource.createProgrammerArtPack(pPackConstructor, () -> ClientPackSource.createProgrammerArtDirPack(file2));
        }
        return pack;
    }

    @Nullable
    private static Pack createProgrammerArtPack(Pack.PackConstructor p_118559_, Supplier<PackResources> p_118560_) {
        return Pack.create(PROGRAMMER_ART_ID, false, p_118560_, p_118559_, Pack.Position.TOP, PackSource.BUILT_IN);
    }

    private static FolderPackResources createProgrammerArtDirPack(File pFile) {
        return new FolderPackResources(pFile){

            @Override
            public String getName() {
                return ClientPackSource.PROGRAMMER_ART_NAME;
            }
        };
    }

    private static PackResources createProgrammerArtZipPack(File pFile) {
        return new FilePackResources(pFile){

            @Override
            public String getName() {
                return ClientPackSource.PROGRAMMER_ART_NAME;
            }
        };
    }
}

