/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.AssetIndex;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;

public class DefaultClientPackResources
extends VanillaPackResources {
    private final AssetIndex assetIndex;

    public DefaultClientPackResources(PackMetadataSection pPackMetadata, AssetIndex pAssetIndex) {
        super(pPackMetadata, "minecraft", "realms");
        this.assetIndex = pAssetIndex;
    }

    @Override
    @Nullable
    protected InputStream getResourceAsStream(PackType pType, ResourceLocation pLocation) {
        File file1;
        if (pType == PackType.CLIENT_RESOURCES && (file1 = this.assetIndex.getFile(pLocation)) != null && file1.exists()) {
            try {
                return new FileInputStream(file1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return super.getResourceAsStream(pType, pLocation);
    }

    @Override
    public boolean hasResource(PackType pType, ResourceLocation pLocation) {
        File file1;
        if (pType == PackType.CLIENT_RESOURCES && (file1 = this.assetIndex.getFile(pLocation)) != null && file1.exists()) {
            return true;
        }
        return super.hasResource(pType, pLocation);
    }

    @Override
    @Nullable
    protected InputStream getResourceAsStream(String pPath) {
        File file1 = this.assetIndex.getRootFile(pPath);
        if (file1 != null && file1.exists()) {
            try {
                return new FileInputStream(file1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return super.getResourceAsStream(pPath);
    }

    @Override
    public Collection<ResourceLocation> getResources(PackType pType, String pNamespace, String pPath, int pMaxDepth, Predicate<String> pFilter) {
        Collection<ResourceLocation> collection = super.getResources(pType, pNamespace, pPath, pMaxDepth, pFilter);
        collection.addAll(this.assetIndex.getFiles(pPath, pNamespace, pMaxDepth, pFilter));
        return collection;
    }
}

