/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.AssetIndex;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class DirectAssetIndex
extends AssetIndex {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File assetsDirectory;

    public DirectAssetIndex(File pAssetsDirectory) {
        this.assetsDirectory = pAssetsDirectory;
    }

    @Override
    public File getFile(ResourceLocation pLocation) {
        return new File(this.assetsDirectory, pLocation.toString().replace(':', '/'));
    }

    @Override
    public File getRootFile(String pPath) {
        return new File(this.assetsDirectory, pPath);
    }

    @Override
    public Collection<ResourceLocation> getFiles(String pPath, String pNamespace, int pMaxDepth, Predicate<String> pFilter) {
        Path path = this.assetsDirectory.toPath().resolve(pNamespace);
        try {
            Collection collection;
            try (Stream<Path> stream = Files.walk(path.resolve(pPath), pMaxDepth, new FileVisitOption[0]);){
                collection = stream.filter(p_118655_ -> Files.isRegularFile(p_118655_, new LinkOption[0])).filter(p_118648_ -> !p_118648_.endsWith(".mcmeta")).filter(p_118651_ -> pFilter.test(p_118651_.getFileName().toString())).map(p_118646_ -> new ResourceLocation(pNamespace, path.relativize((Path)p_118646_).toString().replaceAll("\\\\", "/"))).collect(Collectors.toList());
            }
            return collection;
        }
        catch (NoSuchFileException stream) {
        }
        catch (IOException ioexception) {
            LOGGER.warn("Unable to getFiles on {}", (Object)pPath, (Object)ioexception);
        }
        return Collections.emptyList();
    }
}

