/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecureTextureException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;

public class SkinManager {
    public static final String PROPERTY_TEXTURES = "textures";
    private final TextureManager textureManager;
    private final File skinsDirectory;
    private final MinecraftSessionService sessionService;
    private final LoadingCache<String, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>> insecureSkinCache;

    public SkinManager(TextureManager pTextureManager, File pSkinsDirectory, MinecraftSessionService pSessionService) {
        this.textureManager = pTextureManager;
        this.skinsDirectory = pSkinsDirectory;
        this.sessionService = pSessionService;
        this.insecureSkinCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>>(){

            public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> load(String p_118853_) {
                GameProfile gameprofile = new GameProfile(null, "dummy_mcdummyface");
                gameprofile.getProperties().put((Object)SkinManager.PROPERTY_TEXTURES, (Object)new Property(SkinManager.PROPERTY_TEXTURES, p_118853_, ""));
                try {
                    return pSessionService.getTextures(gameprofile, false);
                }
                catch (Throwable throwable) {
                    return ImmutableMap.of();
                }
            }
        });
    }

    public ResourceLocation registerTexture(MinecraftProfileTexture pProfileTexture, MinecraftProfileTexture.Type pTextureType) {
        return this.registerTexture(pProfileTexture, pTextureType, null);
    }

    private ResourceLocation registerTexture(MinecraftProfileTexture pProfileTexture, MinecraftProfileTexture.Type pTextureType, @Nullable SkinTextureCallback pSkinAvailableCallback) {
        String s = Hashing.sha1().hashUnencodedChars((CharSequence)pProfileTexture.getHash()).toString();
        ResourceLocation resourcelocation = new ResourceLocation("skins/" + s);
        AbstractTexture abstracttexture = this.textureManager.getTexture(resourcelocation, MissingTextureAtlasSprite.getTexture());
        if (abstracttexture == MissingTextureAtlasSprite.getTexture()) {
            File file1 = new File(this.skinsDirectory, s.length() > 2 ? s.substring(0, 2) : "xx");
            File file2 = new File(file1, s);
            HttpTexture httptexture = new HttpTexture(file2, pProfileTexture.getUrl(), DefaultPlayerSkin.getDefaultSkin(), pTextureType == MinecraftProfileTexture.Type.SKIN, () -> {
                if (pSkinAvailableCallback != null) {
                    pSkinAvailableCallback.onSkinTextureAvailable(pTextureType, resourcelocation, pProfileTexture);
                }
            });
            this.textureManager.register(resourcelocation, httptexture);
        } else if (pSkinAvailableCallback != null) {
            pSkinAvailableCallback.onSkinTextureAvailable(pTextureType, resourcelocation, pProfileTexture);
        }
        return resourcelocation;
    }

    public void registerSkins(GameProfile pProfile, SkinTextureCallback pSkinAvailableCallback, boolean pRequireSecure) {
        Runnable runnable = () -> {
            HashMap map = Maps.newHashMap();
            try {
                map.putAll(this.sessionService.getTextures(pProfile, pRequireSecure));
            }
            catch (InsecureTextureException insecureTextureException) {
                // empty catch block
            }
            if (map.isEmpty()) {
                pProfile.getProperties().clear();
                if (pProfile.getId().equals(Minecraft.getInstance().getUser().getGameProfile().getId())) {
                    pProfile.getProperties().putAll((Multimap)Minecraft.getInstance().getProfileProperties());
                    map.putAll(this.sessionService.getTextures(pProfile, false));
                } else {
                    this.sessionService.fillProfileProperties(pProfile, pRequireSecure);
                    try {
                        map.putAll(this.sessionService.getTextures(pProfile, pRequireSecure));
                    }
                    catch (InsecureTextureException insecureTextureException) {
                        // empty catch block
                    }
                }
            }
            Minecraft.getInstance().execute(() -> RenderSystem.recordRenderCall(() -> ImmutableList.of((Object)MinecraftProfileTexture.Type.SKIN, (Object)MinecraftProfileTexture.Type.CAPE).forEach(p_174848_ -> {
                if (map.containsKey(p_174848_)) {
                    this.registerTexture((MinecraftProfileTexture)map.get(p_174848_), (MinecraftProfileTexture.Type)p_174848_, pSkinAvailableCallback);
                }
            })));
        };
        Util.backgroundExecutor().execute(runnable);
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getInsecureSkinInformation(GameProfile pProfile) {
        Property property = (Property)Iterables.getFirst((Iterable)pProfile.getProperties().get((Object)PROPERTY_TEXTURES), null);
        return property == null ? ImmutableMap.of() : (Map)this.insecureSkinCache.getUnchecked((Object)property.getValue());
    }

    public static interface SkinTextureCallback {
        public void onSkinTextureAvailable(MinecraftProfileTexture.Type var1, ResourceLocation var2, MinecraftProfileTexture var3);
    }
}

